/***************************************************************************
                          kgeoSearchRoutines.cpp  -  description
                             -------------------
    begin                : Sun Sep 17 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kgeo.h"

void	KGeoApp::getObjectsRecursion( GeoObjects *obj, QList <GeoObjects>& list )
{
	list.append( obj );

	GeoObjects *actual;
  QListIterator<GeoObjects> iter ( obj->children );

	for ( actual = iter.toFirst(); actual; actual = ++iter )
	{
		if ( !list.contains( actual ) )
 		{
			getObjectsRecursion( actual, list );
  	}
	}
}

void	KGeoApp::getChildren( GeoObjects *obj, QList <GeoObjects>& list )
{
	list.clear();
	getObjectsRecursion( obj, list );
	list.removeFirst();
}

void	KGeoApp::getAllMovableObjects( QPoint *pt, QList <GeoObjects>& list )
{
	GeoObjects *actual;
  QListIterator<GeoObjects> iter( objectList );

	list.clear();

	for ( actual = iter.toFirst(); actual; actual = ++iter )
	{
		if ( actual->contains( pt ) )
 		{
			if ( actual->getMovable() )
 			{
				list.append( actual );
  		}	
  	}
	}
}

void	KGeoApp::getAllMovableObjects( Coordinates & coords, QList <GeoObjects>& list )
{
	GeoObjects *actual;
  QListIterator<GeoObjects> iter( objectList );
	QPoint pt = coords.getQPoint();

	list.clear();

	for ( actual = iter.toFirst(); actual; actual = ++iter )
	{
		if ( actual->contains( &pt ) )
 		{
			if ( actual->getMovable() )
 			{
				list.append( actual );
  		}	
  	}
	}
}

void	KGeoApp::getAllValidObjects( GeoObjects *obj, QPoint *pt, QList <GeoObjects>& list )
{
	GeoObjects *actual;
  QListIterator<GeoObjects> iter( objectList );

	list.clear();

	for ( actual = iter.toFirst(); actual; actual = ++iter )
	{
		if ( actual->contains( pt ) )
 		{
			if ( obj->validParameter( actual ) )
 			{
				list.append( actual );
  		}	
  	}
	}
}

void	KGeoApp::getInvertedList(	QList <GeoObjects>& list1,
																QList <GeoObjects>& list2,
																QList <GeoObjects>& list3 )
{
	GeoObjects *actual;
  QListIterator<GeoObjects> it( list1 );

 	for ( actual = it.toFirst(); actual; actual = ++it )
 	{
 		if ( ! list2.containsRef( actual ) )
 		{
 			list3.append( actual );
 		}
 	}
}
