/***************************************************************************
                          mirrorpoint.cpp  -  description
                             -------------------
    begin                : Tue Oct 31 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mirrorpoint.h"

MirrorPoint::MirrorPoint(): GeoPoint()
{
	identificator = "MirrorPoint";
	ID = ID_mirrorPoint;

	acceptsGeoPoint = true;

	int temp[] = { ID_geoPoint, 2, -1, ID_geoPoint, 1, ID_segment, 1, -1 };
	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
}

MirrorPoint::~MirrorPoint()
{
}

void MirrorPoint::move()
{
	if ( isTrace )
	{
		trace.append( new QRect( surroundingRect ) );
	}

	Coordinates coord1, coord2, coord3, coord4;
	//	If none of the parents is a segment, we mirror point on point.
  if ( (parents.at( 0 )->identify()!= QString( "Segment" )) &&
       ( parents.at( 1 )->identify()!=QString( "Segment" )  ))
	{
	 	coord2 = parents.first()->getCoordinates();
  	coord1 = parents.next()->getCoordinates();
	}
  else if ( parents.at( 0 )->identify()==QString( "Segment" ) )
	{
		coord3 = parents.first()->parents.first()->getCoordinates();
		coord4 = parents.current()->parents.next()->getCoordinates();
  	coord2 = parents.next()->getCoordinates();
  	coord1 = parents.current()->getCoordinates();
		MetricsCenter::mapPointToLine( coord1, coord3, coord4 );
	}
	else
	{
  	coord2 = parents.first()->getCoordinates();
  	coord1 = parents.first()->getCoordinates();
		coord3 = parents.next()->parents.first()->getCoordinates();
		coord4 = parents.current()->parents.next()->getCoordinates();
		MetricsCenter::mapPointToLine( coord1, coord3, coord4 );
	}

	coords = coord1 - coord2;
	coords *= 2;
	coords += coord2;

	//	Calculate new rectangle around point.
	if ( ( size % 2 ) == 0 )
		size += 1;

	int x = coords.getI_X() - ( ( size - 1 ) / 2 );
	int y = coords.getI_Y() - ( ( size - 1 ) / 2 );

	//  Set rectangle.
	surroundingRect = QRect ( x ,y ,size ,size );
}

