#include "AddDlFree.moc"
#include <qwidget.h>
#include <qlabel.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kurlrequester.h>
#include <kapplication.h>

AddDlFree::AddDlFree(bool dir, QWidget * parent, char * wname)
 : KURLRequesterDlg(QString::null, 
                    dir ? i18n("Directory:") : i18n("Filename:"),
                    parent, wname)
{
	isDir=dir;
	if(isDir)
		setCaption(i18n("Add Freely Downloadable Directory"));
	else
		setCaption(i18n("Add Freely Downloadable File"));

	if(isDir)
		urlRequester()->setMode(KFile::ExistingOnly | KFile::LocalOnly | KFile::Directory);
	else
		urlRequester()->setMode(KFile::ExistingOnly | KFile::LocalOnly | KFile::File);
}
AddDlFree::~AddDlFree()
{
}
void AddDlFree::slotOk()
{
	QString f=urlRequester()->url();
	if(!f.isEmpty())
		emit dlFreeAdded(isDir,f);
	accept();
}
