// MailValidator: Control behavior of QLineEdit requesting e-mail address

#include "MailValidator.moc"
#include <ctype.h>
#include <qstring.h>

MailValidator::MailValidator(QLineEdit *parent, const char * name):QValidator(parent,name)
{
}
MailValidator::~MailValidator()
{
}
QValidator::State MailValidator::validate(QString &input, int &) const
{
	QChar c;
	for(unsigned int i=0;i<input.length();i++) {
		c=input.at(i);
		if(!isalnum(c) && c!='@' && c!='.' && c!='_' && c!='+' && c!='-')
			return QValidator::Invalid;
	}
	if(input.find('@')!=input.findRev('@'))
		return QValidator::Invalid;
	if(input.at(input.length()-1)=='@')
		return QValidator::Acceptable;
	return QValidator::Valid;
}
void MailValidator::fixup(QString &)
{
	// Not yet implemented...
}
