/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __keyboardpageimpl_h__
#define __keyboardpageimpl_h__

#include "keyboardpage.h"
#include <klistbox.h>

#include "kxpage.h"
#include "kxdata.h"

class KXKeyboardLayout;
class KXKeyboardModel;

class KeyboardPage : public KeyboardPageBase, public KXPage
{
    Q_OBJECT
    Q_PROPERTY( QString quickHelp READ quickHelp )

public:
    KeyboardPage( QWidget *parent, const char *name = 0 );
    virtual ~KeyboardPage();

    virtual bool eventFilter( QObject *obj, QEvent *e );

    QString quickHelp() const;

    bool get_layout_from_item(QListBoxItem *item,KXKeyboardLayout& layout);
    bool get_model_from_item(QListBoxItem *item ,KXKeyboardModel&  model);


    // reimplemented from KXPage
    virtual void load();
    virtual void save();

public slots:
    void revert();

signals:
    void changed();
    void enableForward( bool );

protected:
    void set( const QString &layout, const QString &model );

private:
    KXKeyboardData originalKeyboard;
};

#endif
