/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pminterior.h"
#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"
#include "pminterioredit.h"

#include <kdebug.h>
#include "pmglobals.h"
#include <klocale.h>

bool PMInterior::s_linkPossibilitiesCreated = false;
QValueList<PMDeclare::PMDeclareType> PMInterior::s_linkPossibilities;

const double iorDefault = 1.0;
const double causticsDefault = 0.0;
const double fadeDistanceDefault = 0.0;
const double fadePowerDefault = 0.0;

PMInterior::PMInterior( )
      : Base( )
{
  m_ior = iorDefault;
  m_caustics = causticsDefault;
  m_fadeDistance = fadeDistanceDefault;
  m_fadePower = fadePowerDefault;
  m_enableIor = false;
  m_enableCaustics = false;
  m_enableFadeDistance = false;
  m_enableFadePower = false;
}

PMInterior::~PMInterior( )
{
}

bool PMInterior::isA( PMObjectType t ) const
{
   if( t == PMTInterior )
      return true;
   return Base::isA( t );
}

QString PMInterior::description( ) const
{
   return i18n( "interior" );
}

bool PMInterior::canInsert( PMObjectType t, const PMObject*,
                           const PMObjectList* ) const
{
   switch( t )
   {
      case PMTMedia:
      case PMTComment:
      case PMTRaw:
         return true;
         break;
      default:
         break;
   }
   return false;
}

void PMInterior::serialize( PMOutputDevice& dev ) const
{
   QString str1;

   dev.objectBegin( "interior" );
   Base::serialize( dev );

   if( m_enableIor )
   {
      str1.setNum( m_ior );
      dev.writeLine( "ior " + str1 );
   }
   if( m_enableCaustics )
   {
      str1.setNum( m_caustics );
      dev.writeLine( "caustics " + str1 );
   }
   if( m_enableFadeDistance )
   {
      str1.setNum( m_fadeDistance );
      dev.writeLine( "fade_distance " + str1 );
   } 
   if( m_enableFadeDistance )
   {
      str1.setNum( m_fadeDistance );
      dev.writeLine( "fade_distance " + str1 );
   }
   dev.objectEnd( );
}

void PMInterior::serialize( QDomElement& e, QDomDocument& doc ) const
{
   Base::serialize( e, doc );
   e.setAttribute( "enable_ior", m_enableIor );
   e.setAttribute( "enable_caustics", m_enableCaustics );
   e.setAttribute( "enable_fade_distance", m_enableFadeDistance );
   e.setAttribute( "enable_fade_power", m_enableFadePower );
   e.setAttribute( "ior", m_ior );
   e.setAttribute( "caustics", m_caustics );
   e.setAttribute( "fade_distance", m_fadeDistance );
   e.setAttribute( "fade_power", m_fadePower );
}
 
void PMInterior::readAttributes( const PMXMLHelper& h )
{
   Base::readAttributes( h );
   m_enableIor = h.boolAttribute( "enable_ior", false );
   m_enableCaustics = h.boolAttribute( "enable_caustics", false );
   m_enableFadeDistance = h.boolAttribute( "enable_fade_distance", false );
   m_enableFadePower = h.boolAttribute( "enable_fade_power", false );
   m_ior = h.doubleAttribute( "ior", iorDefault );
   m_caustics = h.doubleAttribute( "caustics", causticsDefault );
   m_fadeDistance = h.doubleAttribute( "fade_distance", fadeDistanceDefault );
   m_fadePower = h.doubleAttribute( "fade_power", fadePowerDefault );
}

QValueList<PMDeclare::PMDeclareType> PMInterior::linkPossibilities( ) const
{
   if( !s_linkPossibilitiesCreated )
   {
      s_linkPossibilities.append( PMDeclare::InteriorDeclare );
      s_linkPossibilitiesCreated = true;
   }
   return s_linkPossibilities;
}

void PMInterior::setIor( double c )
{
   if( c != m_ior )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTInterior, PMIorID, m_ior );
      m_ior = c;
   }
}
 
void PMInterior::setCaustics( double c )
{
   if( c != m_caustics )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTInterior, PMCausticsID, m_caustics );
      m_caustics = c;
   }
}
 
void PMInterior::setFadeDistance( double c )
{
   if( c != m_fadeDistance )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTInterior, PMFadeDistanceID, m_fadeDistance );
      m_fadeDistance = c;
   }
}

void PMInterior::setFadePower( double c )
{
   if( c != m_fadePower )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTInterior, PMFadePowerID, m_fadePower );
      m_fadePower = c;
   }
}
 
void PMInterior::enableIor( bool c )
{
   if( c != m_enableIor )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTInterior, PMEnableIorID, m_enableIor );
      m_enableIor = c;
   }
}

void PMInterior::enableCaustics( bool c )
{
   if( c != m_enableCaustics )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTInterior, PMEnableCausticsID, m_enableCaustics );
      m_enableCaustics = c;
   }
}

void PMInterior::enableFadeDistance( bool c )
{
   if( c != m_enableFadeDistance )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTInterior, PMEnableFadeDistanceID,
                                                          m_enableFadeDistance );
      m_enableFadeDistance = c;
   }
}

void PMInterior::enableFadePower( bool c )
{
   if( c != m_enableFadePower )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTInterior, PMEnableFadePowerID,
                                                          m_enableFadePower );
      m_enableFadePower = c;
   }
}

PMDialogEditBase* PMInterior::editWidget( QWidget* parent ) const
{
   return new PMInteriorEdit( parent );
}

void PMInterior::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;
 
   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTInterior )
      {
         switch( data->valueID( ) )
         {
            case PMIorID:
               setIor( data->doubleData( ) );
               break;
            case PMCausticsID:
               setCaustics( data->doubleData( ) );
               break;
            case PMFadeDistanceID:
               setFadeDistance( data->doubleData( ) );
               break;
           case PMFadePowerID:
               setFadePower( data->doubleData( ) );
               break;
            case PMEnableIorID:
               enableIor( data->boolData( ) );
               break;
            case PMEnableCausticsID:
               enableCaustics( data->boolData( ) );
               break;
            case PMEnableFadeDistanceID:
               enableFadeDistance( data->boolData( ) );
               break;
            case PMEnableFadePowerID:
               enableFadePower( data->boolData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMInterior::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}
