/***************************************************************************
                         chooser.cpp  -  description
                             -------------------
    begin                : Tue Nov 9 1999
    copyright            : (C) 1999 by Harald Hoyer
    email                : Harald.Hoyer@RedHat.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "DXdmcp.h"
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include <X11/Xlib.h>
#include <X11/keysym.h>

#include <stdlib.h>
#include <time.h>
#include <sys/stat.h>
#include <config.h>

static const char description[] = I18N_NOOP("Login chooser for Xdmcp");

static const char version[] = "v0.1";

static ChooserDlg *kchooser = 0;


class MyApp:public KApplication {

  public:
    virtual bool x11EventFilter(XEvent *);
};


bool MyApp::x11EventFilter(XEvent * ev)
{
    // Hack to tell dialogs to take focus
    if (ev->type == ConfigureNotify) {
	QWidget *target = QWidget::find(((XConfigureEvent *) ev)->window);
	if (target) {
	    target = target->topLevelWidget();
	    if (target->isVisible() && !target->isPopup())
		XSetInputFocus(qt_xdisplay(), target->winId(),
			       RevertToParent, CurrentTime);
	}
    }

    return FALSE;
}

static KCmdLineOptions options[] = {
    {"xdmaddress <addr>", I18N_NOOP("Specify the chooser socket (in hex)"), 0},
    {"clientaddress <addr>", I18N_NOOP("Specify the client ip (in hex)"), 0},
    {"connectionType <type>", I18N_NOOP("Specify the connection type (in dec)"), 0},
    {"+[host]", I18N_NOOP("Specify the hosts to list or use BROADCAST"), 0},
    KCmdLineLastOption
};

#define HOME "/var/tmp/kchooser"

int main(int argc, char **argv)
{
    int i;
    struct stat st;

    for (i = 0; i < 10; i++) {
	if (lstat(HOME, &st))
	    mkdir(HOME, 0700);
	else if (!S_ISDIR(st.st_mode) || st.st_uid != getuid())
	    system("rm -rf " HOME);
	else
	    goto okay;
    }
    Die( EX_UNMANAGE_DPY, "Cannot create $HOME\n" );
  okay:
    if (setenv( "HOME", HOME, 1 ))
	Die( EX_UNMANAGE_DPY, "Cannot set $HOME\n" );

    KApplication::disableAutoDcopRegistration();

    KCmdLineArgs::init(argc, argv, "chooser", description, version);
    KCmdLineArgs::addCmdLineOptions(options);

    setenv( "KDE_DEBUG", "1", 1 );	// prevent KCrash installation
    MyApp app;

    CXdmcp *cxdmcp = new CXdmcp();

    kchooser = new ChooserDlg(cxdmcp);

    app.setMainWidget(kchooser);

    kchooser->show();
    kchooser->ping();
    app.exec();

    Exit(EX_NORMAL);
}
