/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2003  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>

#include <string.h>

#include <glib.h>
#include <gtk/gtk.h>

#include <pan/base/pan-i18n.h>
#include <pan/dialogs/dialogs.h>
#include <pan/dialogs/pan-about.h>

static char * get_credits_code (void);
static char * get_credits_users (void);
static char * get_credits_translators (void);

/**
 * dialog_about:
 *
 * About window to display program information, version number, and
 * copyright.
 **/
void
dialog_about (GtkWidget * window)
{
	char * pch;
	char * credits_bugs;
	char * credits_i18n;
	char * credits_code;
	GtkWidget * about;

	about = pan_about_new (GTK_WINDOW(window),
	                       "Pan", VERSION,
	                       _("A newsreader for GNOME"),
	                       _("Copyright (C) 2003 Charles Kerr"),
	                       PAN_ABOUT_LICENSE_GPL,
	                       "http://pan.rebelbase.com/");

	pan_about_add_author (about, "Charles Kerr", "charles@rebelbase.com",
	                      _("Programmer"));
	pan_about_add_author (about, "Christophe Lambin", "clambin@easynet.be",
	                      _("Programmer"));
	pan_about_add_author (about, "Matt Eagleson", "e.Messiah@superpimp.org",
	                      _("Project Originator, Programmer"));
	pan_about_add_author (about, "Jason Leach", NULL,
	                      _("Programmer, 0.6 - 0.7"));

	credits_i18n = get_credits_translators ();
	credits_code = get_credits_code ();
	credits_bugs = get_credits_users ();
	pch = g_strdup_printf (_("Pan %s Translations\n%s\n"
                                 "\n"
                                 "Pan %s Code or Patches\n%s\n"
                                 "\n"
                                 "Pan %s Suggestions and Testing\n%s\n"),
	                         VERSION, credits_i18n,
	                         VERSION, credits_code,
	                         VERSION, credits_bugs);
	pan_about_add_text (about, _("Thanks"), pch);
	g_free (credits_i18n);
	g_free (credits_code);
	g_free (credits_bugs);
	g_free (pch);

	gtk_widget_show (about);
}


static char *
get_credits_translators (void)
{
	const char * str =
		"\n\tcs - Miloslav Trmac"
		"\n\tde - Benjamin Greiner"
		"\n\tes - Pablo Gonzalo del Campo"
		"\n\tet - Tivo Leedjrv"
		"\n\tfr - Christophe Merlet"
		"\n\tja - KAMAGASAKO Masatoshi"
		"\n\tlv - Artis Trops"
		"\n\tno - Kjartan Maraas"
		"\n\tnl - Vincent van Adrighem"
		"\n\tpl - GNOME PL Team"
		"\n\tpt - Duarte Loreto"
		"\n\tpt_BR - Evandro Fernandes Giovanini"
		"\n\tsk - Marcel Telka"
		"\n\tsv - Christian Rose"
		"\n\ttr - Arman Aksoy (Armish)";
	return g_convert (str, strlen(str), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
}

static char *
get_credits_code (void)
{
	const char * str = 
		"\n\tK. Haley"
		"\n\tTorstein Sunde";
	return g_convert (str, strlen(str), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
}

static char *
get_credits_users (void)
{
	const char * str = 
		"\n\tJohn Aldrich (#114500)"
		"\n\tAugilius (#111867)"
		"\n\tSbastien Baguette (#110366)"
		"\n\tAlberto BARSELLA"
		"\n\tRob Bedford (#111714)"
		"\n\tMichael Van Biesbrouck (#117345, #118152)"
		"\n\tJan Van Besien (#121017)"
		"\n\tJ. Gardner Biggs (#119228)"
		"\n\tKelsey Bjarnason (#118152)"
		"\n\tDave Blamire-Brown (#115659)"
		"\n\tAnton Bossenbroek (#118739, #118740)"
		"\n\tBruce Bowler (#108757)"
		"\n\tBobby D. Bryant (#113602, #113771, #118354, #119153)"
		"\n\tLloyd Budd (#117017)"
		"\n\tDevin Carraway (#117535)"
		"\n\tLucius Chiaraviglio (#119359)"
		"\n\tSimon Cooke (#107321)"
		"\n\tFrederic Crozat (#118746)"
		"\n\tFrank Van Damme (#114354)"
		"\n\tMark Derricutt (#119058)"
		"\n\tDuncan (#118545, #119969)"
		"\n\tMatthew Fischer (#112724)"
		"\n\tThomas K. Gamble (#110428)"
		"\n\tQuentin Garnier (#112624)"
		"\n\tGauze (#91979)"
		"\n\tNicolas Girard (#116319, #117183, #117516, #117187)"
		"\n\tGollum (#107377)"
		"\n\tJakob Breivik Grimstveit (#119948)"
		"\n\tSam Guidice"
		"\n\tK. Haley"
		"\n\tHelge Hielscher (#118894)"
		"\n\tDave Hill (#111790, #111873, #112826, #114514, #116646, #118131, #118804, #118930)"
		"\n\tDevilKin (#113362, #114350, #114464)"
		"\n\tDon Horsman (#112120, #113405)"
		"\n\tCarl Hudkins (#112142)"
		"\n\tPaul Hudson (#109281)"
		"\n\tAdam Huffman (#120079)"
		"\n\tJohan (#111044, #116933, #117173)"
		"\n\tPaul Johnson (#115922, #116655)"
		"\n\tJubal (111620, #104470)"
		"\n\tSamuli Krkkinen (#119013, #110314)"
		"\n\tSebastian Kapfer (#118976)"
		"\n\tBrian Key (#115239)"
		"\n\tBevis King (#120765)"
		"\n\tThomas Klausner (#110833)"
		"\n\tSteve Lamb (#115469)"
		"\n\tLenroc (#119154, #119201, #119686)"
		"\n\tAchim Linder"
		"\n\tJan De Luyck (#117542, #118588, #118589, #119253)"
		"\n\tMahaleo (#117694)"
		"\n\tMark (#109578)"
		"\n\tBlue Meanie (#112818)"
		"\n\tBrian Morrison (#119783)"
		"\n\tUwe Naumann (#119363)"
		"\n\tSoren Boll Overgaard (#90524, #118972, #120159)"
		"\n\tTihomir Pantovic (#116906, #119887)"
		"\n\tChris Petersen (#117181)"
		"\n\tPhoenix Reads (#119748)"
		"\n\tNick Pinney (#115683)"
		"\n\tT. G. Reaper (#117651)"
		"\n\tGuy Rouillier (#118169)"
		"\n\tAlan Sanderson (#120221)"
		"\n\tJerry Walters Segers (#102491)"
		"\n\tBrad Sims (#104866, #118544)"
		"\n\tAlexander Skwar (#112695)"
		"\n\tTorstein Sunde (#119516, #119527)"
		"\n\tValgrind (#118797)"
		"\n\tNiki Waibel (#117141)"
		"\n\tTom Warkentin (#113265)"
		"\n\tWarren (#119575)"
		"\n\tPiotr Wajnberg (#112764)"
		"\n\tMichael Waters (#112812)";
	return g_convert (str, strlen(str), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
}
