/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.protocol.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

class Connection
extends HttpURLConnection {
    protected Socket sock;
    private static Hashtable defRequestProperties = new Hashtable();
    private Hashtable requestProperties;
    private Hashtable hdrHash;
    private Vector hdrVec;
    private BufferedInputStream bufferedIn;
    private static int proxyPort = 80;
    private static boolean proxyInUse = false;
    private static String proxyHost = null;

    private /* synthetic */ void finit$() {
        this.sock = null;
        this.hdrHash = new Hashtable();
        this.hdrVec = new Vector();
    }

    public Connection(URL url) {
        super(url);
        this.finit$();
        this.requestProperties = (Hashtable)defRequestProperties.clone();
    }

    public static void setDefaultRequestProperty(String key, String value) {
        defRequestProperties.put(key, value);
    }

    public static String getDefaultRequestProperty(String key) {
        return (String)defRequestProperties.get(key);
    }

    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalAccessError("Connection already established.");
        }
        this.requestProperties.put(key, value);
    }

    public String getRequestProperty(String key) {
        if (this.connected) {
            throw new IllegalAccessError("Connection already established.");
        }
        return (String)this.requestProperties.get(key);
    }

    public void connect() throws IOException {
        int port;
        if (this.connected) {
            return;
        }
        if (proxyInUse) {
            port = proxyPort;
            this.sock = new Socket(proxyHost, port);
        } else {
            InetAddress destAddr = InetAddress.getByName(this.url.getHost());
            port = this.url.getPort();
            if (port == -1) {
                port = 80;
            }
            this.sock = new Socket(destAddr, port);
        }
        PrintWriter out = new PrintWriter(this.sock.getOutputStream());
        out.print(this.getRequestMethod() + " " + this.url.getFile() + " HTTP/1.0\n");
        out.print("Host: " + this.url.getHost() + ":" + port + "\n");
        Enumeration reqKeys = this.requestProperties.keys();
        Enumeration reqVals = this.requestProperties.elements();
        while (reqKeys.hasMoreElements()) {
            out.print(reqKeys.nextElement() + ": " + reqVals.nextElement() + "\n");
        }
        out.print("\n");
        out.flush();
        this.getHttpHeaders();
        this.connected = true;
    }

    public void disconnect() {
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sock = null;
        }
    }

    public boolean usingProxy() {
        return proxyInUse;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        return this.bufferedIn;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doOutput) {
            throw new ProtocolException("Can't open OutputStream if doOutput is false");
        }
        return this.sock.getOutputStream();
    }

    public String getHeaderField(String name) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException x) {
                return null;
            }
        }
        return (String)this.hdrHash.get(name.toLowerCase());
    }

    public Map getHeaderFields() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException x) {
                return null;
            }
        }
        return this.hdrHash;
    }

    public String getHeaderField(int n) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException x) {
                return null;
            }
        }
        if (n < this.hdrVec.size()) {
            return this.getField((String)this.hdrVec.elementAt(n));
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException x) {
                return null;
            }
        }
        if (n < this.hdrVec.size()) {
            return this.getKey((String)this.hdrVec.elementAt(n));
        }
        return null;
    }

    private String getKey(String str) {
        if (str == null) {
            return null;
        }
        int index = str.indexOf(58);
        if (index >= 0) {
            return str.substring(0, index);
        }
        return null;
    }

    private String getField(String str) {
        if (str == null) {
            return null;
        }
        int index = str.indexOf(58);
        if (index >= 0) {
            return str.substring(index + 1).trim();
        }
        return str;
    }

    private void getHttpHeaders() throws IOException {
        this.bufferedIn = new BufferedInputStream(this.sock.getInputStream());
        int buflen = 100;
        byte[] buf = new byte[buflen];
        String line = "";
        boolean gotnl = false;
        byte[] ch = new byte[]{10};
        while (true) {
            int i;
            if (ch[0] != 10) {
                line = line + '\r' + new String(ch, 0, 1);
            }
            for (i = 0; i < buflen; ++i) {
                buf[i] = (byte)this.bufferedIn.read();
                if (buf[i] == -1) {
                    throw new IOException("Malformed HTTP header");
                }
                if (buf[i] != 13) continue;
                this.bufferedIn.read(ch, 0, 1);
                if (ch[0] != 10) break;
                gotnl = true;
                break;
            }
            line = line + new String(buf, 0, i);
            if (!gotnl) continue;
            if (line.length() == 0) break;
            this.hdrVec.addElement(line);
            String key = this.getKey(line);
            if (key != null) {
                this.hdrHash.put(key.toLowerCase(), this.getField(line));
            }
            line = "";
            ch[0] = 10;
            gotnl = false;
        }
    }

    static {
        String port = null;
        proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null) {
            proxyInUse = true;
            port = System.getProperty("http.proxyPort");
            if (port != null) {
                try {
                    proxyPort = Integer.parseInt(port);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

