/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.runtime;

import gnu.gcj.RawData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class NameFinder {
    private static final boolean demangle = Boolean.valueOf(System.getProperty("gnu.gcj.runtime.NameFinder.demangle", "true"));
    private static final boolean sanitize = Boolean.valueOf(System.getProperty("gnu.gcj.runtime.NameFinder.sanitize", "true"));
    private static final boolean remove_unknown = Boolean.valueOf(System.getProperty("gnu.gcj.runtime.NameFinder.remove_unknown", "true"));
    private static final boolean remove_interpreter = Boolean.valueOf(System.getProperty("gnu.gcj.runtime.NameFinder.remove_interpreter", "true"));
    private static final boolean use_addr2line = Boolean.valueOf(System.getProperty("gnu.gcj.runtime.NameFinder.use_addr2line", "true"));
    private final String executable;
    private Process cppfilt;
    private BufferedWriter cppfiltOut;
    private BufferedReader cppfiltIn;
    private Process addr2line;
    private BufferedWriter addr2lineOut;
    private BufferedReader addr2lineIn;
    private boolean usingAddr2name;

    private /* synthetic */ void finit$() {
        this.usingAddr2name = false;
    }

    public NameFinder() {
        String[] exec;
        this.finit$();
        this.executable = NameFinder.getExecutable();
        Runtime runtime = Runtime.getRuntime();
        if (demangle) {
            try {
                exec = new String[]{"c++filt", "-s", "java"};
                this.cppfilt = runtime.exec(exec);
                this.cppfiltIn = new BufferedReader(new InputStreamReader(this.cppfilt.getInputStream()));
                this.cppfiltOut = new BufferedWriter(new OutputStreamWriter(this.cppfilt.getOutputStream()));
            }
            catch (IOException ioe) {
                if (this.cppfilt != null) {
                    this.cppfilt.destroy();
                }
                this.cppfilt = null;
            }
        }
        if (use_addr2line) {
            try {
                exec = new String[]{"addr2line", "-f", "-e", this.executable};
                this.addr2line = runtime.exec(exec);
            }
            catch (IOException ioe) {
                try {
                    String[] exec2 = new String[]{"addr2name.awk", this.executable};
                    this.addr2line = runtime.exec(exec2);
                    this.usingAddr2name = true;
                }
                catch (IOException ioe2) {
                    this.addr2line = null;
                }
            }
            if (this.addr2line != null) {
                try {
                    this.addr2lineIn = new BufferedReader(new InputStreamReader(this.addr2line.getInputStream()));
                    this.addr2lineOut = new BufferedWriter(new OutputStreamWriter(this.addr2line.getOutputStream()));
                }
                catch (IOException ioe) {
                    this.addr2line.destroy();
                    this.addr2line = null;
                }
            }
        }
    }

    private static native String getExecutable();

    private native StackTraceElement dladdrLookup(RawData var1, int var2);

    private native String getAddrAsString(RawData var1, int var2);

    private native String getExternalLabel(String var1);

    private native StackTraceElement lookupInterp(RawData var1, int var2);

    private StackTraceElement lookup(RawData addrs, int n) {
        StackTraceElement result = this.lookupInterp(addrs, n);
        if (result == null) {
            result = this.dladdrLookup(addrs, n);
        }
        if (result == null) {
            String name = null;
            String file = null;
            String hex = this.getAddrAsString(addrs, n);
            if (this.addr2line != null) {
                try {
                    this.addr2lineOut.write(hex);
                    this.addr2lineOut.newLine();
                    this.addr2lineOut.flush();
                    name = this.addr2lineIn.readLine();
                    file = this.addr2lineIn.readLine();
                    if (!this.usingAddr2name && name != null && !"??".equals(name)) {
                        name = this.getExternalLabel(name);
                    }
                }
                catch (IOException ioe) {
                    this.addr2line = null;
                }
            }
            if (name == null || "??".equals(name)) {
                name = hex;
            }
            result = this.createStackTraceElement(name, file);
        }
        return result;
    }

    public StackTraceElement[] lookup(Throwable t, RawData addrs, int length) {
        StackTraceElement[] elements = new StackTraceElement[length];
        for (int i = 0; i < length; ++i) {
            elements[i] = this.lookup(addrs, i);
        }
        if (demangle && sanitize) {
            return NameFinder.sanitizeStack(elements, t);
        }
        return elements;
    }

    private static StackTraceElement[] sanitizeStack(StackTraceElement[] elements, Throwable t) {
        StackTraceElement[] stack;
        String className = t.getClass().getName();
        int lastDot = className.lastIndexOf(46);
        String consName = lastDot == -1 ? className + '(' : className.substring(lastDot + 1) + '(';
        int unknown = 0;
        int interpreter = 0;
        int last_throw = -1;
        int length = elements.length;
        int end = length - 1;
        for (int i = 0; i < length; ++i) {
            String CName = elements[i].getClassName();
            String MName = elements[i].getMethodName();
            if (CName == null && MName != null && MName.startsWith("_Jv_Throw") || CName != null && (CName.equals(className) || CName.equals("java.lang.Throwable") || CName.equals("java.lang.VMThrowable")) && MName != null && (MName.startsWith(consName) || MName.startsWith("Throwable(") || MName.startsWith("fillInStackTrace("))) {
                last_throw = i;
                unknown = 0;
                interpreter = 0;
                continue;
            }
            if (remove_unknown && CName == null && (MName == null || MName.startsWith("0x"))) {
                ++unknown;
                continue;
            }
            if (remove_interpreter && (CName == null && MName != null && MName.startsWith("ffi_") || CName != null && CName.equals("_Jv_InterpMethod"))) {
                ++interpreter;
                continue;
            }
            if (!"main(java.lang.String[])".equals(MName)) continue;
            end = i;
            break;
        }
        int begin = last_throw + 1;
        int nr_elements = end - begin - unknown - interpreter + 1;
        if ((begin > 0 || end < length - 1 || unknown > 0 || interpreter > 0) && nr_elements > 0) {
            stack = new StackTraceElement[nr_elements];
            int pos = 0;
            for (int i = begin; i <= end; ++i) {
                String MName = elements[i].getMethodName();
                String CName = elements[i].getClassName();
                if (remove_unknown && CName == null && (MName == null || MName.startsWith("0x")) || remove_interpreter && (CName == null && MName != null && MName.startsWith("ffi_") || CName != null && CName.equals("_Jv_InterpMethod"))) continue;
                stack[pos] = elements[i];
                ++pos;
            }
        } else {
            stack = elements;
        }
        return stack;
    }

    private StackTraceElement createStackTraceElement(String name, String file) {
        int dot;
        String s;
        if (!demangle) {
            return new StackTraceElement(file, -1, null, name, false);
        }
        String methodName = s = this.demangleName(name);
        String className = null;
        int bracket = s.indexOf(40);
        if (bracket > 0 && (dot = s.lastIndexOf(46, bracket)) > 0) {
            className = s.substring(0, dot);
            methodName = s.substring(dot + 1, s.length());
        }
        String fileName = file;
        int line = -1;
        if (fileName != null) {
            int colon = file.lastIndexOf(58);
            if (colon > 0) {
                fileName = file.substring(0, colon);
                try {
                    line = Integer.parseInt(file.substring(colon + 1, file.length()));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (line == 0) {
                line = -1;
            }
            if ("".equals(fileName) || "??".equals(fileName)) {
                fileName = null;
            } else if (fileName != null) {
                try {
                    fileName = new File(fileName).getCanonicalPath();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        return new StackTraceElement(fileName, line, className, methodName, false);
    }

    private String demangleName(String s) {
        if (this.cppfilt != null) {
            try {
                this.cppfiltOut.write(s);
                this.cppfiltOut.newLine();
                this.cppfiltOut.flush();
                return this.cppfiltIn.readLine();
            }
            catch (IOException ioe) {
                this.cppfilt.destroy();
                this.cppfilt = null;
            }
        }
        return s;
    }

    public static String demangleInterpreterMethod(String m, String cn) {
        int c;
        int i;
        int index = 0;
        int length = m.length();
        StringBuffer sb = new StringBuffer(length);
        if (m.startsWith("<init>")) {
            i = cn.lastIndexOf(46);
            String className = i < 0 ? cn : cn.substring(i + 1);
            sb.append(className);
            index += 7;
        } else {
            i = m.indexOf(40);
            if (i > 0) {
                sb.append(m.substring(0, i));
                index += i + 1;
            }
        }
        sb.append('(');
        int arrayDepth = 0;
        int n = c = index < length ? (int)m.charAt(index) : 41;
        while (c != 41) {
            int nc;
            String type;
            switch (c) {
                case 66: {
                    type = "byte";
                    break;
                }
                case 67: {
                    type = "char";
                    break;
                }
                case 68: {
                    type = "double";
                    break;
                }
                case 70: {
                    type = "float";
                    break;
                }
                case 73: {
                    type = "int";
                    break;
                }
                case 74: {
                    type = "long";
                    break;
                }
                case 83: {
                    type = "short";
                    break;
                }
                case 90: {
                    type = "boolean";
                    break;
                }
                case 76: {
                    int i2 = m.indexOf(59, index);
                    if (i2 > 0) {
                        type = m.substring(index + 1, i2);
                        index = i2;
                        break;
                    }
                    type = "<unknown ref>";
                    break;
                }
                case 91: {
                    type = "";
                    ++arrayDepth;
                    break;
                }
                default: {
                    type = "<unknown " + (char)c + '>';
                }
            }
            sb.append(type);
            if (c != 91 && arrayDepth > 0) {
                while (arrayDepth > 0) {
                    sb.append("[]");
                    --arrayDepth;
                }
            }
            int n2 = nc = ++index < length ? (int)m.charAt(index) : 41;
            if (c != 91 && nc != 41) {
                sb.append(", ");
            }
            c = nc;
        }
        sb.append(')');
        return sb.toString();
    }

    public void close() {
        if (this.cppfilt != null) {
            this.cppfilt.destroy();
        }
        if (this.addr2line != null) {
            this.addr2line.destroy();
        }
    }

    protected void finalize() {
        this.close();
    }
}

