/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.ByteBufferImpl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;

public final class IntBufferImpl
extends IntBuffer {
    private boolean readOnly;

    public IntBufferImpl(int cap, int off, int lim) {
        super(cap, lim, off, 0);
        this.backing_buffer = new int[cap];
        this.readOnly = false;
    }

    public IntBufferImpl(int[] array, int offset, int length) {
        super(array.length, length, offset, 0);
        this.backing_buffer = array;
        this.readOnly = false;
    }

    public IntBufferImpl(IntBufferImpl copy) {
        super(copy.capacity(), copy.limit(), copy.position(), 0);
        this.backing_buffer = copy.backing_buffer;
        this.readOnly = copy.isReadOnly();
    }

    private static native int[] nio_cast(byte[] var0);

    IntBufferImpl(byte[] copy) {
        super(copy.length, copy.length, 0, 0);
        this.backing_buffer = copy != null ? IntBufferImpl.nio_cast(copy) : null;
        this.readOnly = false;
    }

    private static native byte nio_get_Byte(IntBufferImpl var0, int var1, int var2);

    private static native void nio_put_Byte(IntBufferImpl var0, int var1, int var2, byte var3);

    public ByteBuffer asByteBuffer() {
        ByteBufferImpl res = new ByteBufferImpl(this.backing_buffer);
        res.limit(this.limit() * 1 / 4);
        return res;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public IntBuffer slice() {
        return new IntBufferImpl(this);
    }

    public IntBuffer duplicate() {
        return new IntBufferImpl(this);
    }

    public IntBuffer asReadOnlyBuffer() {
        IntBufferImpl result = new IntBufferImpl(this);
        result.readOnly = true;
        return result;
    }

    public IntBuffer compact() {
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public final int get() {
        int e = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return e;
    }

    public final IntBuffer put(int b) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = b;
        this.position(this.position() + 1);
        return this;
    }

    public final int get(int index) {
        return this.backing_buffer[index];
    }

    public final IntBuffer put(int index, int b) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[index] = b;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }
}

