/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.provider.DefaultPolicy;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecurityPermission;

public abstract class Policy {
    private static Policy currentPolicy = null;

    public static Policy getPolicy() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("getPolicy"));
        }
        return currentPolicy;
    }

    public static void setPolicy(Policy policy) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        currentPolicy = policy;
    }

    public abstract PermissionCollection getPermissions(CodeSource var1);

    public abstract void refresh();

    static {
        String pp = System.getProperty("policy.provider");
        if (pp != null) {
            try {
                currentPolicy = (Policy)Class.forName(pp).newInstance();
            }
            catch (Exception _) {
                currentPolicy = null;
            }
        }
        if (currentPolicy == null) {
            currentPolicy = new DefaultPolicy();
        }
    }
}

