/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.SimpleTimeZone;

public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private String ID;
    private static TimeZone defaultZone;
    private static final long serialVersionUID = 3581463369166924961L;
    private static final Hashtable timezones;

    private static native String getDefaultTimeZoneId();

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int getRawOffset();

    public abstract void setRawOffset(int var1);

    public String getID() {
        return this.ID;
    }

    public void setID(String id) {
        this.ID = id;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean dst, int style) {
        return this.getDisplayName(dst, style, Locale.getDefault());
    }

    public String getDisplayName(boolean dst, int style, Locale locale) {
        try {
            DateFormatSymbols dfs = new DateFormatSymbols(locale);
            String[][] zoneinfo = dfs.getZoneStrings();
            for (int i = 0; i < zoneinfo.length; ++i) {
                if (!zoneinfo[i][0].equals(this.getID())) continue;
                if (!dst) {
                    if (style == 0) {
                        return zoneinfo[i][2];
                    }
                    return zoneinfo[i][1];
                }
                if (style == 0) {
                    return zoneinfo[i][4];
                }
                return zoneinfo[i][3];
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return this.getDefaultDisplayName(dst);
    }

    private String getDefaultDisplayName(boolean dst) {
        int offset = this.getRawOffset();
        if (dst && this instanceof SimpleTimeZone) {
            offset += ((SimpleTimeZone)this).getDSTSavings();
        }
        StringBuffer sb = new StringBuffer(9);
        sb.append("GMT");
        sb.append(offset >= 0 ? (char)'+' : '-');
        offset = Math.abs(offset) / 60000;
        int hours = offset / 60;
        int minutes = offset % 60;
        sb.append((char)(48 + hours / 10)).append((char)(48 + hours % 10));
        sb.append(':');
        sb.append((char)(48 + minutes / 10)).append((char)(48 + minutes % 10));
        return sb.toString();
    }

    public abstract boolean useDaylightTime();

    public abstract boolean inDaylightTime(Date var1);

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public static TimeZone getTimeZone(String ID) {
        TimeZone tz = (TimeZone)timezones.get(ID);
        if (tz != null) {
            if (tz.getID().equals(ID)) {
                return tz;
            }
            tz = (TimeZone)tz.clone();
            tz.setID(ID);
            timezones.put(ID, tz);
            return tz;
        }
        if (ID.startsWith("GMT")) {
            int pos = 3;
            int offset_direction = 1;
            if (ID.charAt(pos) == '-') {
                offset_direction = -1;
                ++pos;
            } else if (ID.charAt(pos) == '+') {
                ++pos;
            }
            try {
                int minute;
                int hour;
                String offset_str = ID.substring(pos);
                int idx = offset_str.indexOf(":");
                if (idx != -1) {
                    hour = Integer.parseInt(offset_str.substring(0, idx));
                    minute = Integer.parseInt(offset_str.substring(idx + 1));
                } else {
                    int offset_length = offset_str.length();
                    if (offset_length <= 2) {
                        hour = Integer.parseInt(offset_str);
                        minute = 0;
                    } else {
                        hour = Integer.parseInt(offset_str.substring(0, offset_length - 2));
                        minute = Integer.parseInt(offset_str.substring(offset_length - 2));
                    }
                }
                return new SimpleTimeZone((hour * 3600000 + minute * 60000) * offset_direction, ID);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return TimeZone.getTimeZone("GMT");
    }

    public static String[] getAvailableIDs(int rawOffset) {
        int count = 0;
        Iterator iter = timezones.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (((TimeZone)entry.getValue()).getRawOffset() != rawOffset) continue;
            ++count;
        }
        String[] ids = new String[count];
        count = 0;
        iter = timezones.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (((TimeZone)entry.getValue()).getRawOffset() != rawOffset) continue;
            ids[count++] = (String)entry.getKey();
        }
        return ids;
    }

    public static String[] getAvailableIDs() {
        return (String[])timezones.keySet().toArray(new String[timezones.size()]);
    }

    public static TimeZone getDefault() {
        return defaultZone;
    }

    public static void setDefault(TimeZone zone) {
        defaultZone = zone;
    }

    public boolean hasSameRules(TimeZone other) {
        return other.getRawOffset() == this.getRawOffset();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    static {
        timezones = new Hashtable();
        SimpleTimeZone tz = new SimpleTimeZone(-39600000, "MIT");
        timezones.put("MIT", tz);
        timezones.put("Pacific/Apia", tz);
        timezones.put("Pacific/Midway", tz);
        timezones.put("Pacific/Niue", tz);
        timezones.put("Pacific/Pago_Pago", tz);
        tz = new SimpleTimeZone(-36000000, "America/Adak", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("America/Adak", tz);
        tz = new SimpleTimeZone(-36000000, "HST");
        timezones.put("HST", tz);
        timezones.put("Pacific/Fakaofo", tz);
        timezones.put("Pacific/Honolulu", tz);
        timezones.put("Pacific/Johnston", tz);
        timezones.put("Pacific/Rarotonga", tz);
        timezones.put("Pacific/Tahiti", tz);
        tz = new SimpleTimeZone(-34200000, "Pacific/Marquesas");
        timezones.put("Pacific/Marquesas", tz);
        tz = new SimpleTimeZone(-32400000, "AST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("AST", tz);
        timezones.put("America/Anchorage", tz);
        timezones.put("America/Juneau", tz);
        timezones.put("America/Nome", tz);
        timezones.put("America/Yakutat", tz);
        tz = new SimpleTimeZone(-32400000, "Pacific/Gambier");
        timezones.put("Pacific/Gambier", tz);
        tz = new SimpleTimeZone(-28800000, "PST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("PST", tz);
        timezones.put("PST8PDT", tz);
        timezones.put("America/Dawson", tz);
        timezones.put("America/Los_Angeles", tz);
        timezones.put("America/Tijuana", tz);
        timezones.put("America/Vancouver", tz);
        timezones.put("America/Whitehorse", tz);
        timezones.put("US/Pacific-New", tz);
        tz = new SimpleTimeZone(-28800000, "Pacific/Pitcairn");
        timezones.put("Pacific/Pitcairn", tz);
        tz = new SimpleTimeZone(-25200000, "MST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("MST", tz);
        timezones.put("MST7MDT", tz);
        timezones.put("America/Boise", tz);
        timezones.put("America/Chihuahua", tz);
        timezones.put("America/Denver", tz);
        timezones.put("America/Edmonton", tz);
        timezones.put("America/Inuvik", tz);
        timezones.put("America/Mazatlan", tz);
        timezones.put("America/Shiprock", tz);
        timezones.put("America/Yellowknife", tz);
        tz = new SimpleTimeZone(-25200000, "MST7");
        timezones.put("MST7", tz);
        timezones.put("PNT", tz);
        timezones.put("America/Dawson_Creek", tz);
        timezones.put("America/Hermosillo", tz);
        timezones.put("America/Phoenix", tz);
        tz = new SimpleTimeZone(-21600000, "CST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("CST", tz);
        timezones.put("CST6CDT", tz);
        timezones.put("America/Cambridge_Bay", tz);
        timezones.put("America/Cancun", tz);
        timezones.put("America/Chicago", tz);
        timezones.put("America/Menominee", tz);
        timezones.put("America/Merida", tz);
        timezones.put("America/Mexico_City", tz);
        timezones.put("America/Monterrey", tz);
        timezones.put("America/Rainy_River", tz);
        timezones.put("America/Winnipeg", tz);
        tz = new SimpleTimeZone(-21600000, "America/Belize");
        timezones.put("America/Belize", tz);
        timezones.put("America/Costa_Rica", tz);
        timezones.put("America/El_Salvador", tz);
        timezones.put("America/Guatemala", tz);
        timezones.put("America/Managua", tz);
        timezones.put("America/Regina", tz);
        timezones.put("America/Swift_Current", tz);
        timezones.put("America/Tegucigalpa", tz);
        timezones.put("Pacific/Galapagos", tz);
        tz = new SimpleTimeZone(-21600000, "Pacific/Easter", 9, 9, -1, 0, 2, 9, -1, 0);
        timezones.put("Pacific/Easter", tz);
        tz = new SimpleTimeZone(-18000000, "America/Grand_Turk", 3, 1, 1, 0, 9, -1, 1, 0);
        timezones.put("America/Grand_Turk", tz);
        timezones.put("America/Havana", tz);
        tz = new SimpleTimeZone(-18000000, "EST5");
        timezones.put("EST5", tz);
        timezones.put("IET", tz);
        timezones.put("America/Bogota", tz);
        timezones.put("America/Cayman", tz);
        timezones.put("America/Eirunepe", tz);
        timezones.put("America/Guayaquil", tz);
        timezones.put("America/Indiana/Indianapolis", tz);
        timezones.put("America/Indiana/Knox", tz);
        timezones.put("America/Indiana/Marengo", tz);
        timezones.put("America/Indiana/Vevay", tz);
        timezones.put("America/Indianapolis", tz);
        timezones.put("America/Iqaluit", tz);
        timezones.put("America/Jamaica", tz);
        timezones.put("America/Lima", tz);
        timezones.put("America/Panama", tz);
        timezones.put("America/Pangnirtung", tz);
        timezones.put("America/Port-au-Prince", tz);
        timezones.put("America/Porto_Acre", tz);
        timezones.put("America/Rankin_Inlet", tz);
        tz = new SimpleTimeZone(-18000000, "EST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("EST", tz);
        timezones.put("EST5EDT", tz);
        timezones.put("America/Detroit", tz);
        timezones.put("America/Kentucky/Louisville", tz);
        timezones.put("America/Kentucky/Monticello", tz);
        timezones.put("America/Louisville", tz);
        timezones.put("America/Montreal", tz);
        timezones.put("America/Nassau", tz);
        timezones.put("America/New_York", tz);
        timezones.put("America/Nipigon", tz);
        timezones.put("America/Thunder_Bay", tz);
        tz = new SimpleTimeZone(-14400000, "PRT");
        timezones.put("PRT", tz);
        timezones.put("America/Anguilla", tz);
        timezones.put("America/Antigua", tz);
        timezones.put("America/Aruba", tz);
        timezones.put("America/Barbados", tz);
        timezones.put("America/Boa_Vista", tz);
        timezones.put("America/Caracas", tz);
        timezones.put("America/Curacao", tz);
        timezones.put("America/Dominica", tz);
        timezones.put("America/Grenada", tz);
        timezones.put("America/Guadeloupe", tz);
        timezones.put("America/Guyana", tz);
        timezones.put("America/La_Paz", tz);
        timezones.put("America/Manaus", tz);
        timezones.put("America/Martinique", tz);
        timezones.put("America/Montserrat", tz);
        timezones.put("America/Port_of_Spain", tz);
        timezones.put("America/Porto_Velho", tz);
        timezones.put("America/Puerto_Rico", tz);
        timezones.put("America/Santo_Domingo", tz);
        timezones.put("America/St_Kitts", tz);
        timezones.put("America/St_Lucia", tz);
        timezones.put("America/St_Thomas", tz);
        timezones.put("America/St_Vincent", tz);
        timezones.put("America/Tortola", tz);
        tz = new SimpleTimeZone(-14400000, "America/Asuncion", 9, 1, 1, 0, 1, -1, 1, 0);
        timezones.put("America/Asuncion", tz);
        tz = new SimpleTimeZone(-14400000, "America/Cuiaba", 9, 2, 1, 0, 1, 3, 1, 0);
        timezones.put("America/Cuiaba", tz);
        tz = new SimpleTimeZone(-14400000, "America/Goose_Bay", 3, 1, 1, 60000, 9, -1, 1, 60000);
        timezones.put("America/Goose_Bay", tz);
        tz = new SimpleTimeZone(-14400000, "America/Glace_Bay", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("America/Glace_Bay", tz);
        timezones.put("America/Halifax", tz);
        timezones.put("America/Thule", tz);
        timezones.put("Atlantic/Bermuda", tz);
        tz = new SimpleTimeZone(-14400000, "America/Santiago", 9, 9, -1, 0, 2, 9, -1, 0);
        timezones.put("America/Santiago", tz);
        timezones.put("Antarctica/Palmer", tz);
        tz = new SimpleTimeZone(-14400000, "Atlantic/Stanley", 8, 2, 1, 0, 3, 16, -1, 0);
        timezones.put("Atlantic/Stanley", tz);
        tz = new SimpleTimeZone(-12600000, "CNT", 3, 1, 1, 60000, 9, -1, 1, 60000);
        timezones.put("CNT", tz);
        timezones.put("America/St_Johns", tz);
        tz = new SimpleTimeZone(-10800000, "America/Araguaina", 9, 2, 1, 0, 1, 3, 1, 0);
        timezones.put("America/Araguaina", tz);
        timezones.put("America/Sao_Paulo", tz);
        tz = new SimpleTimeZone(-10800000, "AGT");
        timezones.put("AGT", tz);
        timezones.put("America/Belem", tz);
        timezones.put("America/Buenos_Aires", tz);
        timezones.put("America/Catamarca", tz);
        timezones.put("America/Cayenne", tz);
        timezones.put("America/Cordoba", tz);
        timezones.put("America/Fortaleza", tz);
        timezones.put("America/Jujuy", tz);
        timezones.put("America/Maceio", tz);
        timezones.put("America/Mendoza", tz);
        timezones.put("America/Montevideo", tz);
        timezones.put("America/Paramaribo", tz);
        timezones.put("America/Recife", tz);
        timezones.put("America/Rosario", tz);
        tz = new SimpleTimeZone(-10800000, "America/Godthab", 2, 30, -7, 79200000, 9, 30, -7, 79200000);
        timezones.put("America/Godthab", tz);
        tz = new SimpleTimeZone(-10800000, "America/Miquelon", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("America/Miquelon", tz);
        tz = new SimpleTimeZone(-7200000, "America/Noronha");
        timezones.put("America/Noronha", tz);
        timezones.put("Atlantic/South_Georgia", tz);
        tz = new SimpleTimeZone(-3600000, "America/Scoresbysund", 2, -1, 1, 0, 9, -1, 1, 0);
        timezones.put("America/Scoresbysund", tz);
        timezones.put("Atlantic/Azores", tz);
        tz = new SimpleTimeZone(-3600000, "Atlantic/Cape_Verde");
        timezones.put("Atlantic/Cape_Verde", tz);
        timezones.put("Atlantic/Jan_Mayen", tz);
        tz = new SimpleTimeZone(0, "GMT");
        timezones.put("GMT", tz);
        timezones.put("UTC", tz);
        timezones.put("Africa/Abidjan", tz);
        timezones.put("Africa/Accra", tz);
        timezones.put("Africa/Bamako", tz);
        timezones.put("Africa/Banjul", tz);
        timezones.put("Africa/Bissau", tz);
        timezones.put("Africa/Casablanca", tz);
        timezones.put("Africa/Conakry", tz);
        timezones.put("Africa/Dakar", tz);
        timezones.put("Africa/El_Aaiun", tz);
        timezones.put("Africa/Freetown", tz);
        timezones.put("Africa/Lome", tz);
        timezones.put("Africa/Monrovia", tz);
        timezones.put("Africa/Nouakchott", tz);
        timezones.put("Africa/Ouagadougou", tz);
        timezones.put("Africa/Sao_Tome", tz);
        timezones.put("Africa/Timbuktu", tz);
        timezones.put("Atlantic/Reykjavik", tz);
        timezones.put("Atlantic/St_Helena", tz);
        timezones.put("Europe/Belfast", tz);
        timezones.put("Europe/Dublin", tz);
        timezones.put("Europe/London", tz);
        tz = new SimpleTimeZone(0, "WET", 2, -1, 1, 3600000, 9, -1, 1, 3600000);
        timezones.put("WET", tz);
        timezones.put("Atlantic/Canary", tz);
        timezones.put("Atlantic/Faeroe", tz);
        timezones.put("Atlantic/Madeira", tz);
        timezones.put("Europe/Lisbon", tz);
        tz = new SimpleTimeZone(3600000, "Africa/Algiers");
        timezones.put("Africa/Algiers", tz);
        timezones.put("Africa/Bangui", tz);
        timezones.put("Africa/Brazzaville", tz);
        timezones.put("Africa/Douala", tz);
        timezones.put("Africa/Kinshasa", tz);
        timezones.put("Africa/Lagos", tz);
        timezones.put("Africa/Libreville", tz);
        timezones.put("Africa/Luanda", tz);
        timezones.put("Africa/Malabo", tz);
        timezones.put("Africa/Ndjamena", tz);
        timezones.put("Africa/Niamey", tz);
        timezones.put("Africa/Porto-Novo", tz);
        timezones.put("Africa/Tunis", tz);
        tz = new SimpleTimeZone(3600000, "Africa/Windhoek", 8, 1, 1, 0x6DDD00, 3, 1, 1, 0x6DDD00);
        timezones.put("Africa/Windhoek", tz);
        tz = new SimpleTimeZone(3600000, "CET", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("CET", tz);
        timezones.put("ECT", tz);
        timezones.put("MET", tz);
        timezones.put("Africa/Ceuta", tz);
        timezones.put("Arctic/Longyearbyen", tz);
        timezones.put("Europe/Amsterdam", tz);
        timezones.put("Europe/Andorra", tz);
        timezones.put("Europe/Belgrade", tz);
        timezones.put("Europe/Berlin", tz);
        timezones.put("Europe/Bratislava", tz);
        timezones.put("Europe/Brussels", tz);
        timezones.put("Europe/Budapest", tz);
        timezones.put("Europe/Copenhagen", tz);
        timezones.put("Europe/Gibraltar", tz);
        timezones.put("Europe/Ljubljana", tz);
        timezones.put("Europe/Luxembourg", tz);
        timezones.put("Europe/Madrid", tz);
        timezones.put("Europe/Malta", tz);
        timezones.put("Europe/Monaco", tz);
        timezones.put("Europe/Oslo", tz);
        timezones.put("Europe/Paris", tz);
        timezones.put("Europe/Prague", tz);
        timezones.put("Europe/Rome", tz);
        timezones.put("Europe/San_Marino", tz);
        timezones.put("Europe/Sarajevo", tz);
        timezones.put("Europe/Skopje", tz);
        timezones.put("Europe/Stockholm", tz);
        timezones.put("Europe/Tirane", tz);
        timezones.put("Europe/Vaduz", tz);
        timezones.put("Europe/Vatican", tz);
        timezones.put("Europe/Vienna", tz);
        timezones.put("Europe/Warsaw", tz);
        timezones.put("Europe/Zagreb", tz);
        timezones.put("Europe/Zurich", tz);
        tz = new SimpleTimeZone(0x6DDD00, "ART", 3, -1, 6, 0, 8, -1, 5, 82800000);
        timezones.put("ART", tz);
        timezones.put("Africa/Cairo", tz);
        tz = new SimpleTimeZone(0x6DDD00, "CAT");
        timezones.put("CAT", tz);
        timezones.put("Africa/Blantyre", tz);
        timezones.put("Africa/Bujumbura", tz);
        timezones.put("Africa/Gaborone", tz);
        timezones.put("Africa/Harare", tz);
        timezones.put("Africa/Johannesburg", tz);
        timezones.put("Africa/Kigali", tz);
        timezones.put("Africa/Lubumbashi", tz);
        timezones.put("Africa/Lusaka", tz);
        timezones.put("Africa/Maputo", tz);
        timezones.put("Africa/Maseru", tz);
        timezones.put("Africa/Mbabane", tz);
        timezones.put("Africa/Tripoli", tz);
        timezones.put("Europe/Riga", tz);
        timezones.put("Europe/Tallinn", tz);
        timezones.put("Europe/Vilnius", tz);
        tz = new SimpleTimeZone(0x6DDD00, "Asia/Amman", 2, -1, 5, 0, 8, -1, 5, 0);
        timezones.put("Asia/Amman", tz);
        tz = new SimpleTimeZone(0x6DDD00, "Asia/Beirut", 2, -1, 1, 0, 9, -1, 1, 0);
        timezones.put("Asia/Beirut", tz);
        tz = new SimpleTimeZone(0x6DDD00, "Asia/Damascus", 3, 1, 0, 0, 9, 1, 0, 0);
        timezones.put("Asia/Damascus", tz);
        tz = new SimpleTimeZone(0x6DDD00, "Asia/Gaza", 3, 3, 6, 0, 9, 3, 6, 0);
        timezones.put("Asia/Gaza", tz);
        tz = new SimpleTimeZone(0x6DDD00, "Asia/Jerusalem", 3, 1, 0, 3600000, 9, 1, 0, 3600000);
        timezones.put("Asia/Jerusalem", tz);
        tz = new SimpleTimeZone(0x6DDD00, "EET", 2, -1, 1, 10800000, 9, -1, 1, 10800000);
        timezones.put("EET", tz);
        timezones.put("Asia/Istanbul", tz);
        timezones.put("Asia/Nicosia", tz);
        timezones.put("Europe/Athens", tz);
        timezones.put("Europe/Bucharest", tz);
        timezones.put("Europe/Chisinau", tz);
        timezones.put("Europe/Helsinki", tz);
        timezones.put("Europe/Istanbul", tz);
        timezones.put("Europe/Kiev", tz);
        timezones.put("Europe/Nicosia", tz);
        timezones.put("Europe/Simferopol", tz);
        timezones.put("Europe/Sofia", tz);
        timezones.put("Europe/Uzhgorod", tz);
        timezones.put("Europe/Zaporozhye", tz);
        tz = new SimpleTimeZone(0x6DDD00, "Europe/Kaliningrad", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Europe/Kaliningrad", tz);
        timezones.put("Europe/Minsk", tz);
        tz = new SimpleTimeZone(10800000, "Asia/Baghdad", 3, 1, 0, 10800000, 9, 1, 0, 10800000);
        timezones.put("Asia/Baghdad", tz);
        tz = new SimpleTimeZone(10800000, "Europe/Moscow", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Europe/Moscow", tz);
        timezones.put("Europe/Tiraspol", tz);
        tz = new SimpleTimeZone(10800000, "EAT");
        timezones.put("EAT", tz);
        timezones.put("Africa/Addis_Ababa", tz);
        timezones.put("Africa/Asmera", tz);
        timezones.put("Africa/Dar_es_Salaam", tz);
        timezones.put("Africa/Djibouti", tz);
        timezones.put("Africa/Kampala", tz);
        timezones.put("Africa/Khartoum", tz);
        timezones.put("Africa/Mogadishu", tz);
        timezones.put("Africa/Nairobi", tz);
        timezones.put("Antarctica/Syowa", tz);
        timezones.put("Asia/Aden", tz);
        timezones.put("Asia/Bahrain", tz);
        timezones.put("Asia/Kuwait", tz);
        timezones.put("Asia/Qatar", tz);
        timezones.put("Asia/Riyadh", tz);
        timezones.put("Indian/Antananarivo", tz);
        timezones.put("Indian/Comoro", tz);
        timezones.put("Indian/Mayotte", tz);
        tz = new SimpleTimeZone(12600000, "Asia/Tehran");
        timezones.put("Asia/Tehran", tz);
        tz = new SimpleTimeZone(14400000, "Asia/Baku", 2, -1, 1, 3600000, 9, -1, 1, 3600000);
        timezones.put("Asia/Baku", tz);
        tz = new SimpleTimeZone(14400000, "Asia/Aqtau", 2, -1, 1, 0, 9, -1, 1, 0);
        timezones.put("Asia/Aqtau", tz);
        timezones.put("Asia/Tbilisi", tz);
        tz = new SimpleTimeZone(14400000, "Asia/Yerevan", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Yerevan", tz);
        timezones.put("Europe/Samara", tz);
        tz = new SimpleTimeZone(14400000, "NET");
        timezones.put("NET", tz);
        timezones.put("Asia/Dubai", tz);
        timezones.put("Asia/Muscat", tz);
        timezones.put("Indian/Mahe", tz);
        timezones.put("Indian/Mauritius", tz);
        timezones.put("Indian/Reunion", tz);
        tz = new SimpleTimeZone(16200000, "Asia/Kabul");
        timezones.put("Asia/Kabul", tz);
        tz = new SimpleTimeZone(18000000, "Asia/Aqtobe", 2, -1, 1, 0, 9, -1, 1, 0);
        timezones.put("Asia/Aqtobe", tz);
        tz = new SimpleTimeZone(18000000, "Asia/Bishkek", 2, -1, 1, 9000000, 9, -1, 1, 9000000);
        timezones.put("Asia/Bishkek", tz);
        tz = new SimpleTimeZone(18000000, "Asia/Yekaterinburg", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Yekaterinburg", tz);
        tz = new SimpleTimeZone(18000000, "PLT");
        timezones.put("PLT", tz);
        timezones.put("Asia/Ashgabat", tz);
        timezones.put("Asia/Dushanbe", tz);
        timezones.put("Asia/Karachi", tz);
        timezones.put("Asia/Samarkand", tz);
        timezones.put("Asia/Tashkent", tz);
        timezones.put("Indian/Chagos", tz);
        timezones.put("Indian/Kerguelen", tz);
        timezones.put("Indian/Maldives", tz);
        tz = new SimpleTimeZone(19800000, "IST");
        timezones.put("IST", tz);
        timezones.put("Asia/Calcutta", tz);
        tz = new SimpleTimeZone(20700000, "Asia/Katmandu");
        timezones.put("Asia/Katmandu", tz);
        tz = new SimpleTimeZone(21600000, "BST");
        timezones.put("BST", tz);
        timezones.put("Antarctica/Mawson", tz);
        timezones.put("Asia/Colombo", tz);
        timezones.put("Asia/Dhaka", tz);
        timezones.put("Asia/Thimphu", tz);
        tz = new SimpleTimeZone(21600000, "Asia/Almaty", 2, -1, 1, 0, 9, -1, 1, 0);
        timezones.put("Asia/Almaty", tz);
        tz = new SimpleTimeZone(21600000, "Asia/Novosibirsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Novosibirsk", tz);
        timezones.put("Asia/Omsk", tz);
        tz = new SimpleTimeZone(23400000, "Asia/Rangoon");
        timezones.put("Asia/Rangoon", tz);
        timezones.put("Indian/Cocos", tz);
        tz = new SimpleTimeZone(25200000, "VST");
        timezones.put("VST", tz);
        timezones.put("Antarctica/Davis", tz);
        timezones.put("Asia/Bangkok", tz);
        timezones.put("Asia/Hovd", tz);
        timezones.put("Asia/Jakarta", tz);
        timezones.put("Asia/Phnom_Penh", tz);
        timezones.put("Asia/Saigon", tz);
        timezones.put("Asia/Vientiane", tz);
        timezones.put("Indian/Christmas", tz);
        tz = new SimpleTimeZone(25200000, "Asia/Krasnoyarsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Krasnoyarsk", tz);
        tz = new SimpleTimeZone(28800000, "CTT");
        timezones.put("CTT", tz);
        timezones.put("Antarctica/Casey", tz);
        timezones.put("Asia/Brunei", tz);
        timezones.put("Asia/Chungking", tz);
        timezones.put("Asia/Harbin", tz);
        timezones.put("Asia/Hong_Kong", tz);
        timezones.put("Asia/Kashgar", tz);
        timezones.put("Asia/Kuala_Lumpur", tz);
        timezones.put("Asia/Kuching", tz);
        timezones.put("Asia/Macao", tz);
        timezones.put("Asia/Manila", tz);
        timezones.put("Asia/Shanghai", tz);
        timezones.put("Asia/Singapore", tz);
        timezones.put("Asia/Taipei", tz);
        timezones.put("Asia/Ujung_Pandang", tz);
        timezones.put("Asia/Ulaanbaatar", tz);
        timezones.put("Asia/Urumqi", tz);
        timezones.put("Australia/Perth", tz);
        tz = new SimpleTimeZone(28800000, "Asia/Irkutsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Irkutsk", tz);
        tz = new SimpleTimeZone(32400000, "JST");
        timezones.put("JST", tz);
        timezones.put("Asia/Dili", tz);
        timezones.put("Asia/Jayapura", tz);
        timezones.put("Asia/Pyongyang", tz);
        timezones.put("Asia/Seoul", tz);
        timezones.put("Asia/Tokyo", tz);
        timezones.put("Pacific/Palau", tz);
        tz = new SimpleTimeZone(32400000, "Asia/Yakutsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Yakutsk", tz);
        tz = new SimpleTimeZone(34200000, "Australia/Adelaide", 9, -1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00);
        timezones.put("Australia/Adelaide", tz);
        timezones.put("Australia/Broken_Hill", tz);
        tz = new SimpleTimeZone(34200000, "ACT");
        timezones.put("ACT", tz);
        timezones.put("Australia/Darwin", tz);
        tz = new SimpleTimeZone(36000000, "Antarctica/DumontDUrville");
        timezones.put("Antarctica/DumontDUrville", tz);
        timezones.put("Australia/Brisbane", tz);
        timezones.put("Australia/Lindeman", tz);
        timezones.put("Pacific/Guam", tz);
        timezones.put("Pacific/Port_Moresby", tz);
        timezones.put("Pacific/Saipan", tz);
        timezones.put("Pacific/Truk", tz);
        timezones.put("Pacific/Yap", tz);
        tz = new SimpleTimeZone(36000000, "Asia/Vladivostok", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Vladivostok", tz);
        tz = new SimpleTimeZone(36000000, "Australia/Hobart", 9, 1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00);
        timezones.put("Australia/Hobart", tz);
        tz = new SimpleTimeZone(36000000, "AET", 9, -1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00);
        timezones.put("AET", tz);
        timezones.put("Australia/Melbourne", tz);
        timezones.put("Australia/Sydney", tz);
        tz = new SimpleTimeZone(37800000, "Australia/Lord_Howe", 9, -1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00, 1800000);
        timezones.put("Australia/Lord_Howe", tz);
        tz = new SimpleTimeZone(39600000, "Asia/Magadan", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Magadan", tz);
        tz = new SimpleTimeZone(39600000, "SST");
        timezones.put("SST", tz);
        timezones.put("Pacific/Efate", tz);
        timezones.put("Pacific/Guadalcanal", tz);
        timezones.put("Pacific/Kosrae", tz);
        timezones.put("Pacific/Noumea", tz);
        timezones.put("Pacific/Ponape", tz);
        tz = new SimpleTimeZone(41400000, "Pacific/Norfolk");
        timezones.put("Pacific/Norfolk", tz);
        tz = new SimpleTimeZone(43200000, "NST", 9, 1, 1, 0x6DDD00, 2, 3, 1, 0x6DDD00);
        timezones.put("NST", tz);
        timezones.put("Antarctica/McMurdo", tz);
        timezones.put("Antarctica/South_Pole", tz);
        timezones.put("Pacific/Auckland", tz);
        tz = new SimpleTimeZone(43200000, "Asia/Anadyr", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        timezones.put("Asia/Anadyr", tz);
        timezones.put("Asia/Kamchatka", tz);
        tz = new SimpleTimeZone(43200000, "Pacific/Fiji");
        timezones.put("Pacific/Fiji", tz);
        timezones.put("Pacific/Funafuti", tz);
        timezones.put("Pacific/Kwajalein", tz);
        timezones.put("Pacific/Majuro", tz);
        timezones.put("Pacific/Nauru", tz);
        timezones.put("Pacific/Tarawa", tz);
        timezones.put("Pacific/Wake", tz);
        timezones.put("Pacific/Wallis", tz);
        tz = new SimpleTimeZone(45900000, "Pacific/Chatham", 9, 1, 1, 9900000, 2, 3, 1, 9900000);
        timezones.put("Pacific/Chatham", tz);
        tz = new SimpleTimeZone(46800000, "Pacific/Enderbury");
        timezones.put("Pacific/Enderbury", tz);
        timezones.put("Pacific/Tongatapu", tz);
        tz = new SimpleTimeZone(50400000, "Pacific/Kiritimati");
        timezones.put("Pacific/Kiritimati", tz);
        String tzid = System.getProperty("user.timezone");
        if (tzid == null) {
            tzid = TimeZone.getDefaultTimeZoneId();
        }
        if (tzid == null) {
            tzid = "GMT";
        }
        defaultZone = TimeZone.getTimeZone(tzid);
    }
}

