/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.postgresql;

import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.openrdf.sail.SailException;
import org.openrdf.sail.rdbms.RdbmsStore;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.postgresql.PgSqlConnectionFactory;

public class PgSqlStore
extends RdbmsStore {
    private String serverName;
    private String databaseName;
    private int portNumber;
    private String user;
    private String password;

    public PgSqlStore() {
    }

    public PgSqlStore(String databaseName) {
        this.setDatabaseName(databaseName);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void initialize() throws SailException {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RdbmsException(e.toString(), e);
        }
        StringBuilder url = new StringBuilder();
        url.append("jdbc:postgresql:");
        if (this.serverName != null) {
            url.append("//").append(this.serverName);
            if (this.portNumber > 0) {
                url.append(":").append(this.portNumber);
            }
            url.append("/");
        }
        url.append(this.databaseName);
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl(url.toString());
        if (this.user != null) {
            ds.setUsername(this.user);
        } else {
            ds.setUsername(System.getProperty("user.name"));
        }
        if (this.password != null) {
            ds.setPassword(this.password);
        }
        PgSqlConnectionFactory factory = new PgSqlConnectionFactory();
        factory.setSail(this);
        factory.setDataSource((DataSource)ds);
        this.setConnectionFactory(factory);
        super.initialize();
    }
}

