/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.base;

import info.aduna.iteration.Iteration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.util.RDFInserter;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryConnectionBase
implements RepositoryConnection {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Repository repository;
    private boolean isOpen;
    private boolean autoCommit;
    private Throwable creatorTrace;

    private static boolean debugEnabled() {
        return System.getProperty("org.openrdf.repository.debug") != null;
    }

    protected RepositoryConnectionBase(Repository repository) {
        this.repository = repository;
        this.isOpen = true;
        this.autoCommit = true;
        if (RepositoryConnectionBase.debugEnabled()) {
            this.creatorTrace = new Throwable();
        }
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean isOpen() throws RepositoryException {
        return this.isOpen;
    }

    @Override
    public void close() throws RepositoryException {
        this.isOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.isOpen()) {
                if (this.creatorTrace != null) {
                    this.logger.warn("Closing connection due to garbage collection, connection was create in:", this.creatorTrace);
                }
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareQuery(ql, query, null);
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareTupleQuery(ql, query, null);
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareGraphQuery(ql, query, null);
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareBooleanQuery(ql, query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasStatement(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        RepositoryResult<Statement> stIter = this.getStatements(subj, pred, obj, includeInferred, contexts);
        try {
            boolean bl = stIter.hasNext();
            return bl;
        }
        finally {
            stIter.close();
        }
    }

    @Override
    public boolean hasStatement(Statement st, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        return this.hasStatement(st.getSubject(), st.getPredicate(), st.getObject(), includeInferred, contexts);
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        return this.size(new Resource[0]) == 0L;
    }

    @Override
    public void export(RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        this.exportStatements(null, null, null, false, handler, contexts);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        if (autoCommit == this.autoCommit) {
            return;
        }
        this.autoCommit = autoCommit;
        if (autoCommit) {
            this.commit();
        }
    }

    @Override
    public boolean isAutoCommit() throws RepositoryException {
        return this.autoCommit;
    }

    protected void autoCommit() throws RepositoryException {
        if (this.isAutoCommit()) {
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = file.toURI().toString();
        }
        FileInputStream in = new FileInputStream(file);
        try {
            this.add(in, baseURI, dataFormat, contexts);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (baseURI == null) {
            baseURI = url.toExternalForm();
        }
        InputStream in = url.openStream();
        try {
            this.add(in, baseURI, dataFormat, contexts);
        }
        finally {
            in.close();
        }
    }

    @Override
    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.addInputStreamOrReader(in, baseURI, dataFormat, contexts);
    }

    @Override
    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        this.addInputStreamOrReader(reader, baseURI, dataFormat, contexts);
    }

    protected void addInputStreamOrReader(Object inputStreamOrReader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        block10: {
            OpenRDFUtil.verifyContextNotNull(contexts);
            RDFParser rdfParser = Rio.createParser(dataFormat, this.getRepository().getValueFactory());
            rdfParser.setVerifyData(true);
            rdfParser.setStopAtFirstError(true);
            rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            RDFInserter rdfInserter = new RDFInserter(this);
            rdfInserter.enforceContext(contexts);
            rdfParser.setRDFHandler(rdfInserter);
            boolean autoCommit = this.isAutoCommit();
            this.setAutoCommit(false);
            try {
                if (inputStreamOrReader instanceof InputStream) {
                    rdfParser.parse((InputStream)inputStreamOrReader, baseURI);
                    break block10;
                }
                if (inputStreamOrReader instanceof Reader) {
                    rdfParser.parse((Reader)inputStreamOrReader, baseURI);
                    break block10;
                }
                throw new IllegalArgumentException("inputStreamOrReader must be an InputStream or a Reader, is a: " + inputStreamOrReader.getClass());
            }
            catch (RDFHandlerException e) {
                if (autoCommit) {
                    this.rollback();
                }
                throw (RepositoryException)e.getCause();
            }
            catch (RuntimeException e) {
                if (autoCommit) {
                    this.rollback();
                }
                throw e;
            }
            finally {
                this.setAutoCommit(autoCommit);
            }
        }
    }

    @Override
    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        boolean autoCommit = this.isAutoCommit();
        this.setAutoCommit(false);
        try {
            for (Statement statement : statements) {
                this.addWithoutCommit(statement, contexts);
            }
        }
        catch (RepositoryException e) {
            if (autoCommit) {
                this.rollback();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (autoCommit) {
                this.rollback();
            }
            throw e;
        }
        finally {
            this.setAutoCommit(autoCommit);
        }
    }

    @Override
    public <E extends Exception> void add(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        OpenRDFUtil.verifyContextNotNull(contexts);
        boolean autoCommit = this.isAutoCommit();
        this.setAutoCommit(false);
        try {
            while (statementIter.hasNext()) {
                this.addWithoutCommit(statementIter.next(), contexts);
            }
        }
        catch (RepositoryException e) {
            if (autoCommit) {
                this.rollback();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (autoCommit) {
                this.rollback();
            }
            throw e;
        }
        finally {
            this.setAutoCommit(autoCommit);
        }
    }

    @Override
    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.addWithoutCommit(st, contexts);
        this.autoCommit();
    }

    @Override
    public void add(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.addWithoutCommit(subject, predicate, object, contexts);
        this.autoCommit();
    }

    @Override
    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        boolean autoCommit = this.isAutoCommit();
        this.setAutoCommit(false);
        try {
            for (Statement statement : statements) {
                this.remove(statement, contexts);
            }
        }
        catch (RepositoryException e) {
            if (autoCommit) {
                this.rollback();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (autoCommit) {
                this.rollback();
            }
            throw e;
        }
        finally {
            this.setAutoCommit(autoCommit);
        }
    }

    @Override
    public <E extends Exception> void remove(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        boolean autoCommit = this.isAutoCommit();
        this.setAutoCommit(false);
        try {
            while (statementIter.hasNext()) {
                this.remove(statementIter.next(), contexts);
            }
        }
        catch (RepositoryException e) {
            if (autoCommit) {
                this.rollback();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (autoCommit) {
                this.rollback();
            }
            throw e;
        }
        finally {
            this.setAutoCommit(autoCommit);
        }
    }

    @Override
    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.removeWithoutCommit(st, contexts);
        this.autoCommit();
    }

    @Override
    public void remove(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.removeWithoutCommit(subject, predicate, object, contexts);
        this.autoCommit();
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        this.remove(null, null, null, contexts);
    }

    protected void addWithoutCommit(Statement st, Resource ... contexts) throws RepositoryException {
        if (contexts.length == 0 && st.getContext() != null) {
            contexts = new Resource[]{st.getContext()};
        }
        this.addWithoutCommit(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
    }

    protected abstract void addWithoutCommit(Resource var1, URI var2, Value var3, Resource ... var4) throws RepositoryException;

    protected void removeWithoutCommit(Statement st, Resource ... contexts) throws RepositoryException {
        if (contexts.length == 0 && st.getContext() != null) {
            contexts = new Resource[]{st.getContext()};
        }
        this.removeWithoutCommit(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
    }

    protected abstract void removeWithoutCommit(Resource var1, URI var2, Value var3, Resource ... var4) throws RepositoryException;
}

