/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import info.aduna.iteration.CloseableIteratorIteration;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.http.protocol.transaction.operations.AddStatementOperation;
import org.openrdf.http.protocol.transaction.operations.ClearNamespacesOperation;
import org.openrdf.http.protocol.transaction.operations.ClearOperation;
import org.openrdf.http.protocol.transaction.operations.RemoveNamespaceOperation;
import org.openrdf.http.protocol.transaction.operations.RemoveStatementsOperation;
import org.openrdf.http.protocol.transaction.operations.SetNamespaceOperation;
import org.openrdf.http.protocol.transaction.operations.TransactionOperation;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.base.RepositoryConnectionBase;
import org.openrdf.repository.http.HTTPBooleanQuery;
import org.openrdf.repository.http.HTTPGraphQuery;
import org.openrdf.repository.http.HTTPRepository;
import org.openrdf.repository.http.HTTPTupleQuery;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.StatementCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HTTPRepositoryConnection
extends RepositoryConnectionBase {
    private List<TransactionOperation> txn = Collections.synchronizedList(new ArrayList());

    public HTTPRepositoryConnection(HTTPRepository repository) {
        super(repository);
    }

    @Override
    public HTTPRepository getRepository() {
        return (HTTPRepository)super.getRepository();
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String queryString, String baseURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new HTTPTupleQuery(this, ql, queryString, baseURI);
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new HTTPGraphQuery(this, ql, queryString, baseURI);
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseURI) {
        return new HTTPBooleanQuery(this, ql, queryString, baseURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            ArrayList<Resource> contextList = new ArrayList<Resource>();
            TupleQueryResult contextIDs = this.getRepository().getHTTPClient().getContextIDs();
            try {
                while (contextIDs.hasNext()) {
                    BindingSet bindingSet = (BindingSet)contextIDs.next();
                    Value context = bindingSet.getValue("contextID");
                    if (!(context instanceof Resource)) continue;
                    contextList.add((Resource)context);
                }
            }
            finally {
                contextIDs.close();
            }
            return this.createRepositoryResult(contextList);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException(e);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public RepositoryResult<Statement> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            StatementCollector collector = new StatementCollector();
            this.exportStatements(subj, pred, obj, includeInferred, collector, contexts);
            return this.createRepositoryResult(collector.getStatements());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void exportStatements(Resource subj, URI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RDFHandlerException, RepositoryException {
        try {
            this.getRepository().getHTTPClient().getStatements(subj, pred, obj, includeInferred, handler, contexts);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public long size(Resource ... contexts) throws RepositoryException {
        try {
            return this.getRepository().getHTTPClient().size(contexts);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws RepositoryException {
        List<TransactionOperation> list = this.txn;
        synchronized (list) {
            if (this.txn.size() > 0) {
                try {
                    this.getRepository().getHTTPClient().sendTransaction(this.txn);
                    this.txn.clear();
                }
                catch (IOException e) {
                    throw new RepositoryException(e);
                }
            }
        }
    }

    @Override
    public void rollback() {
        this.txn.clear();
    }

    @Override
    public void close() throws RepositoryException {
        if (this.txn.size() > 0) {
            this.logger.warn("Rolling back transaction due to connection close", new Throwable());
            this.rollback();
        }
        super.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void addInputStreamOrReader(Object inputStreamOrReader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isAutoCommit()) {
            HTTPClient httpClient = this.getRepository().getHTTPClient();
            if (inputStreamOrReader instanceof InputStream) {
                httpClient.upload((InputStream)inputStreamOrReader, baseURI, dataFormat, false, contexts);
                return;
            } else {
                if (!(inputStreamOrReader instanceof Reader)) throw new IllegalArgumentException("inputStreamOrReader must be an InputStream or a Reader, is a: " + inputStreamOrReader.getClass());
                httpClient.upload((Reader)inputStreamOrReader, baseURI, dataFormat, false, contexts);
            }
            return;
        } else {
            super.addInputStreamOrReader(inputStreamOrReader, baseURI, dataFormat, contexts);
        }
    }

    @Override
    protected void addWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.txn.add(new AddStatementOperation(subject, predicate, object, contexts));
    }

    @Override
    protected void removeWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.txn.add(new RemoveStatementsOperation(subject, predicate, object, contexts));
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        this.txn.add(new ClearOperation(contexts));
        this.autoCommit();
    }

    @Override
    public void removeNamespace(String prefix) throws RepositoryException {
        this.txn.add(new RemoveNamespaceOperation(prefix));
        this.autoCommit();
    }

    @Override
    public void clearNamespaces() throws RepositoryException {
        this.txn.add(new ClearNamespacesOperation());
        this.autoCommit();
    }

    @Override
    public void setNamespace(String prefix, String name) throws RepositoryException {
        this.txn.add(new SetNamespaceOperation(prefix, name));
        this.autoCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        try {
            ArrayList<NamespaceImpl> namespaceList = new ArrayList<NamespaceImpl>();
            TupleQueryResult namespaces = this.getRepository().getHTTPClient().getNamespaces();
            try {
                while (namespaces.hasNext()) {
                    BindingSet bindingSet = (BindingSet)namespaces.next();
                    Value prefix = bindingSet.getValue("prefix");
                    Value namespace = bindingSet.getValue("namespace");
                    if (!(prefix instanceof Literal) || !(namespace instanceof Literal)) continue;
                    String prefixStr = ((Literal)prefix).getLabel();
                    String namespaceStr = ((Literal)namespace).getLabel();
                    namespaceList.add(new NamespaceImpl(prefixStr, namespaceStr));
                }
            }
            finally {
                namespaces.close();
            }
            return this.createRepositoryResult(namespaceList);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException(e);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public String getNamespace(String prefix) throws RepositoryException {
        try {
            return this.getRepository().getHTTPClient().getNamespace(prefix);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    protected <E> RepositoryResult<E> createRepositoryResult(Iterable<? extends E> elements) {
        return new RepositoryResult<E>(new CloseableIteratorIteration(elements.iterator()));
    }
}

