; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -march=xcore | FileCheck %s

declare i8 @llvm.bitreverse.i8(i8)
declare i16 @llvm.bitreverse.i16(i16)
declare i32 @llvm.bitreverse.i32(i32)
declare i64 @llvm.bitreverse.i64(i64)

define i8 @bitrev8(i8 %x) nounwind {
; CHECK-LABEL: bitrev8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bitrev r0, r0
; CHECK-NEXT:    shr r0, r0, 24
; CHECK-NEXT:    retsp 0
; CHECK-NEXT:    .cc_bottom bitrev8.function
entry:
  %0 = call i8 @llvm.bitreverse.i8(i8 %x)
  ret i8 %0
}

define i16 @bitrev16(i16 %x) nounwind {
; CHECK-LABEL: bitrev16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bitrev r0, r0
; CHECK-NEXT:    shr r0, r0, 16
; CHECK-NEXT:    retsp 0
; CHECK-NEXT:    .cc_bottom bitrev16.function
entry:
  %0 = call i16 @llvm.bitreverse.i16(i16 %x)
  ret i16 %0
}

define i32 @bitrev32(i32 %x) nounwind {
; CHECK-LABEL: bitrev32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bitrev r0, r0
; CHECK-NEXT:    retsp 0
; CHECK-NEXT:    .cc_bottom bitrev32.function
entry:
  %0 = call i32 @llvm.bitreverse.i32(i32 %x)
  ret i32 %0
}

define i64 @bitrev64(i64 %x) nounwind {
; CHECK-LABEL: bitrev64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    bitrev r2, r1
; CHECK-NEXT:    bitrev r1, r0
; CHECK-NEXT:    mov r0, r2
; CHECK-NEXT:    retsp 0
; CHECK-NEXT:    .cc_bottom bitrev64.function
entry:
  %0 = call i64 @llvm.bitreverse.i64(i64 %x)
  ret i64 %0
}
