struct vector
{
  const char *cipher;
  const char *mode;
  const char *key;
  grub_uint32_t keylen;
  const char *ptext;
  grub_uint32_t plen;
  const char *ctext;
  const char *iv_in;
  const char *iv_out;
  grub_uint32_t ivlen;
} vecs[] = {
  {
    .cipher = "aes",
    .mode   = "ecb",
    .key    = "\x00\x01\x02\x03\x04\x05\x06\x07"
              "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
    .keylen = 16,
    .ptext  = "\x00\x11\x22\x33\x44\x55\x66\x77"
              "\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
    .plen   = 16,
    .ctext  = "\x69\xc4\xe0\xd8\x6a\x7b\x04\x30"
              "\xd8\xcd\xb7\x80\x70\xb4\xc5\x5a",
  },
  {
    .cipher = "aes",
    .mode   = "ecb",
    .key    = "\x00\x01\x02\x03\x04\x05\x06\x07"
              "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
              "\x10\x11\x12\x13\x14\x15\x16\x17",
    .keylen = 24,
    .ptext  = "\x00\x11\x22\x33\x44\x55\x66\x77"
              "\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
    .plen   = 16,
    .ctext  = "\xdd\xa9\x7c\xa4\x86\x4c\xdf\xe0"
              "\x6e\xaf\x70\xa0\xec\x0d\x71\x91",
  },
  {
    .cipher = "aes",
    .mode   = "ecb",
    .key    = "\x00\x01\x02\x03\x04\x05\x06\x07"
              "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
              "\x10\x11\x12\x13\x14\x15\x16\x17"
              "\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
    .keylen = 32,
    .ptext  = "\x00\x11\x22\x33\x44\x55\x66\x77"
              "\x88\x99\xaa\xbb\xcc\xdd\xee\xff",
    .plen   = 16,
    .ctext  = "\x8e\xa2\xb7\xca\x51\x67\x45\xbf"
              "\xea\xfc\x49\x90\x4b\x49\x60\x89",
  },
  {
    .cipher = "aes",
    .mode   = "cbc",
    .key    = "\xc2\x86\x69\x6d\x88\x7c\x9a\xa0"
              "\x61\x1b\xbb\x3e\x20\x25\xa4\x5a",
    .keylen = 16,
    .ptext  = "\x00\x01\x02\x03\x04\x05\x06\x07"
              "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
              "\x10\x11\x12\x13\x14\x15\x16\x17"
              "\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
    .plen   = 32,
    .ctext  = "\xd2\x96\xcd\x94\xc2\xcc\xcf\x8a"
              "\x3a\x86\x30\x28\xb5\xe1\xdc\x0a"
              "\x75\x86\x60\x2d\x25\x3c\xff\xf9"
              "\x1b\x82\x66\xbe\xa6\xd6\x1a\xb1",
    .iv_in  = "\x56\x2e\x17\x99\x6d\x09\x3d\x28"
              "\xdd\xb3\xba\x69\x5a\x2e\x6f\x58",
    .iv_out = "\x75\x86\x60\x2d\x25\x3c\xff\xf9"
              "\x1b\x82\x66\xbe\xa6\xd6\x1a\xb1",
    .ivlen  = 16,
  },
  {
    .cipher = "aes",
    .mode   = "cbc",
    .key    = "\x8e\x73\xb0\xf7\xda\x0e\x64\x52"
              "\xc8\x10\xf3\x2b\x80\x90\x79\xe5"
              "\x62\xf8\xea\xd2\x52\x2c\x6b\x7b",
    .keylen = 24,
    .ptext  = "\x6b\xc1\xbe\xe2\x2e\x40\x9f\x96"
              "\xe9\x3d\x7e\x11\x73\x93\x17\x2a"
              "\xae\x2d\x8a\x57\x1e\x03\xac\x9c"
              "\x9e\xb7\x6f\xac\x45\xaf\x8e\x51"
              "\x30\xc8\x1c\x46\xa3\x5c\xe4\x11"
              "\xe5\xfb\xc1\x19\x1a\x0a\x52\xef"
              "\xf6\x9f\x24\x45\xdf\x4f\x9b\x17"
              "\xad\x2b\x41\x7b\xe6\x6c\x37\x10",
    .plen   = 64,
    .ctext  = "\x4f\x02\x1d\xb2\x43\xbc\x63\x3d"
              "\x71\x78\x18\x3a\x9f\xa0\x71\xe8"
              "\xb4\xd9\xad\xa9\xad\x7d\xed\xf4"
              "\xe5\xe7\x38\x76\x3f\x69\x14\x5a"
              "\x57\x1b\x24\x20\x12\xfb\x7a\xe0"
              "\x7f\xa9\xba\xac\x3d\xf1\x02\xe0"
              "\x08\xb0\xe2\x79\x88\x59\x88\x81"
              "\xd9\x20\xa9\xe6\x4f\x56\x15\xcd",
    .iv_in  = "\x00\x01\x02\x03\x04\x05\x06\x07"
              "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
    .iv_out = "\x08\xb0\xe2\x79\x88\x59\x88\x81"
              "\xd9\x20\xa9\xe6\x4f\x56\x15\xcd",
    .ivlen  = 16,
  },
  {
    .cipher = "aes",
    .mode   = "cbc",
    .key    = "\x60\x3d\xeb\x10\x15\xca\x71\xbe"
              "\x2b\x73\xae\xf0\x85\x7d\x77\x81"
              "\x1f\x35\x2c\x07\x3b\x61\x08\xd7"
              "\x2d\x98\x10\xa3\x09\x14\xdf\xf4",
    .keylen = 32,
    .ptext  = "\x6b\xc1\xbe\xe2\x2e\x40\x9f\x96"
              "\xe9\x3d\x7e\x11\x73\x93\x17\x2a"
              "\xae\x2d\x8a\x57\x1e\x03\xac\x9c"
              "\x9e\xb7\x6f\xac\x45\xaf\x8e\x51"
              "\x30\xc8\x1c\x46\xa3\x5c\xe4\x11"
              "\xe5\xfb\xc1\x19\x1a\x0a\x52\xef"
              "\xf6\x9f\x24\x45\xdf\x4f\x9b\x17"
              "\xad\x2b\x41\x7b\xe6\x6c\x37\x10",
    .plen   = 64,
    .ctext  = "\xf5\x8c\x4c\x04\xd6\xe5\xf1\xba"
              "\x77\x9e\xab\xfb\x5f\x7b\xfb\xd6"
              "\x9c\xfc\x4e\x96\x7e\xdb\x80\x8d"
              "\x67\x9f\x77\x7b\xc6\x70\x2c\x7d"
              "\x39\xf2\x33\x69\xa9\xd9\xba\xcf"
              "\xa5\x30\xe2\x63\x04\x23\x14\x61"
              "\xb2\xeb\x05\xe2\xc3\x9b\xe9\xfc"
              "\xda\x6c\x19\x07\x8c\x6a\x9d\x1b",
    .iv_in  = "\x00\x01\x02\x03\x04\x05\x06\x07"
              "\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
    .iv_out = "\xb2\xeb\x05\xe2\xc3\x9b\xe9\xfc"
              "\xda\x6c\x19\x07\x8c\x6a\x9d\x1b",
    .ivlen  = 16,
  },
};
