## v0.5.0 (2025-08-01):

 * The output from the list subcommands has been tweaked to be more
   consistent. This should help to avoid parsing bugs with
   naively-written programs and scripts that parse the list output.
   This includes various GUI tools.
 * The test suite was expanded to include archives generated by Tascal
   Lha (a Windows CE port); LH/2 (an OS/2 port); ExpLZH; and the port
   of Lha that ships with MorphOS.
 * A workaround was added for a bug with the Amiga port of lha that
   causes some versions to generate malformed archives where
   directories are stored using the -lh0- compression type. Thanks to
   @zzarko, @polluks, @alfredone and @jsummers for their work on
   figuring out the bug.
 * Support was added for the 64-bit file sizes header, allowing huge
   files (>=4GiB) generated by the MorphOS port of lha to be
   extracted correctly.
 * The compression ratio shown in list output now always rounds up to
   the next 0.1%, which is a more pessimistic but more honest. For
   example, very highly compressed files might be shown as "0.1%" of
   their original size, but never "0.0%".
 * The manual page now includes more detailed information about the
   different list subcommands.
 * The liblhasa headers are now installed into a directory with a name
   that accurately reflects the project's version number.
 * The liblhasa .so version numbers now have meaningful numbers.
 * Some error messages were changed to print filenames safely.
 * Several minor memory leaks were fixed.
 * Extraction of DECLHA self-extracting archives was fixed.
 * Tests can now be run correctly in parallel.
 * The Doxygen search feature was enabled for the documentation pages.
 * Undefined behavior in the BitStreamReader code was fixed (thanks
   @sezero)
 * Some static arrays were made constant (thanks Cameron Cawley).
 * Out-of-tree builds were fixed (thanks Daisuke Fujimura)

## v0.4.0 (2023-05-14):

 * The manpage was expanded, with more information about different
   compression formats, example commands, a BUGS section and some
   additional references in the SEE ALSO section.
 * A verbose mode was added to the list output that shows the full file
   timestamp (thanks Dan Fandrich).
 * Support for archives generated by the DOS LHARK tool was added; big
   thanks go to Jason Summers for his tool DEARK and his comprehensive
   writeup on the LHARK format.
 * Some changes were made for compatibility with old versions of
   autotools (thanks Ozkan Sezer).
 * Some tweaks were made to tests to make them work on BSD systems.
 * Segmentation fault on NetBSD/amd64 was fixed when decoding 8-bit
   character filenames (thanks Izumi Tsutsui).
 * Some minor tweaks and fixes were made to the help text and manpage
   (thanks Stefan)
 * Some spelling mistakes were fixed, excess whitespace was trimmed, and
   the website link in the RPC spec file was fixed (thanks a1346054 and
   Jakub Wilk).
 * A potential integer overflow in the lha_decode_*uint32 functions was
   fixed (thanks Jacub Wilk).

## v0.3.1 (2016-03-29):

 * This release fixes an integer underflow vulnerability in the
   code for doing LZH level 3 header decodes (TALOS-CAN-0095).
   Thanks go to Marcin Noga and Regina Wilson of Cisco TALOS for
   reporting this vulnerability.

## v0.3.0 (2015-04-20):

 * PMarc -pm1- archives that contain truncated compressed data (the
   decompressed length is longer than what can be read from the
   compressed data) now decompress as intended. Certain archives
   in the wild make the assumption that this can be done.
 * LArc -lz5- archives that make use of the initial history buffer
   now decompress correctly.
 * The tests no longer use predictable temporary paths (thanks Jon
   Dowland).
 * Tests were fixed under OS X.

## v0.2.0 (2013-08-04):

 * Decompression of archives using the -lhx- file format supported by
   unlha32.dll is now supported (thanks Multi for the patch).
 * The -p (print to stdout) command line option is now supported.
 * The test suite should now run correctly on Windows.

Bugs fixed:

 * Bug where archives read from pipes (eg. stdin) were not extracted
   beyond the first file in the archive.
 * Output when using the -w (extract directory) option now correctly
   matches the output of Unix lha.

## v0.1.0 (2013-03-16):

 * There are now test archives for OS-9 and OS-9/68k (OSK) and a
   workaround for a bug in the OSK lha tool on this platform. OSK level
   0 extended areas are also supported.
 * Extracted files are now written using O_EXCL, which prevents
   malicious symbolic links being used to redirect output.
 * Directory paths containing '..' as a directory name are now
   sanitized, to prevent malicious archives being able to overwrite
   arbitrary files on the filesystem.
 * Symbolic links are now extracted in a safer way, being created as
   dummy files that are overwritten with proper symbolic links at the
   end of extraction. This is the same behavior used by GNU tar to
   prevent malicious use of symbolic links.
 * Automake 1.13 is now properly supported (thanks Jan Engelhardt).
   Processing of archives read from IPC pipes (including stdin) has
   been fixed.

## v0.0.7 (2012-06-02):

 * Extraction and listing of Unix symbolic links is now supported.
 * Decompression code for the "old" PMarc archive algorithm (-pm1-) has
   been added.
 * Support has been added for Unix LHA level 0 header extended areas
   (so level 0 archives with Unix metadata are now listed and extracted
   correctly).
 * The Unix permissions field in the list output for directory entries
   has been fixed.
 * The library header files have been fixed so that they can be included
   in C++ code.
 * The LHADecoder interface, for extracting raw compressed data, has been
   added to the public header files.
 * The Unix LHA test archives have been regenerated and improved.
 * A "ghost testing" tool has been added for testing ghost compression
   algorithms such as -pm1-.
 * The list output tests have been fixed to be repeatable regardless of
   the current date.
 * Build of the fuzzer tool has been fixed.

## v0.0.6 (2012-05-17):

 * When the -w option is used during extraction, the path specified
   is now first created if it does not already exist.
 * The command line tool now exits with a failure return code if an
   error occurs during extraction.
 * A "catch-all" header file (lhasa.h) has been added.
 * The public header files installed with the library can now be
   included and used externally.
 * A pkgconfig file is now installed as part of the library
   (thanks Jan Engelhardt).
 * Make targets have been added for building Doxygen documentation
   and including them as part of the distribution.

## v0.0.5 (2012-05-08):

 * Architecture-specific functions for running on Windows have now been
   fully implemented, and the command line tool passes all tests in the
   test suite on Windows (thanks roytam1 for bug reports).
 * Bug fixed where the command line tool would enter an infinite loop
   when extracting a truncated archive (thanks Jon Dowland).
 * Support added for archives with level 0 headers and Unix path
   separators (thanks roytam1).
 * The test suite now runs correctly outside of the Europe/London time
   zone (thanks Thomas Klausner).
 * A .spec file is now included for building rpm packages.

## v0.0.4 (2012-05-01):

 * Special handling is now included for MacBinary headers generated
   by MacLHA.
 * The -w command line option was broken; it has been fixed.
 * A bug has been fixed where the timestamp and other metadata was
   not set properly for extracted directories.
 * Failures to set the UID/GID of extracted files are now ignored,
   rather than being treated as a fatal error.
 * Self-extracting archive files with long headers (up to 64KiB)
   are now supported. This fixes the handling with some Windows
   archives.
 * A Unix manpage has been added.
 * It is now possible to extract an archive from stdin, by using '-'
   as the filename.
 * The shorthand command line syntax "lha foo.lzh" to list an archive
   is now supported.
 * A bug with the wildcard pattern matching code has been fixed.
 * Proper regression tests have now been added for command line
   archive extraction.
 * A set of archives generated by LHmelt (Windows) have been added to
   the test suite.
 * The regression tests for testing file header parsing and CRC checks
   have been rewritten.

## v0.0.3 (2012-04-22):

Third beta release.

 * A fix has been added for a bug where missing parent directories
   were not being created properly.
 * Regression testing archives have been added from MacLHA v2.24.
 * In order to support MacLHA archives, code has been added that
   heuristically detects the MacBinary headers added by MacLHA
   and strips them off.

## v0.0.2 (2012-04-17):

Second beta release.

 * This version adds support for level 2 and 3 file headers. Lhasa
   should now be capable of decompressing most, if not all archives
   found in the wild.
 * A fuzz testing framework has been added for testing the
   decompression code. A couple of bugs have been fixed as a result
   of this.

## v0.0.1 (2012-04-06):

Initial version. This should be considered beta code, although this
first version should already be capable of extracting the majority of
archive files found in the wild. The main missing features are:

 * Lack of support for level 2 and 3 file headers.
 * Inability to create archives (only extract them).

These are features that I aim to add in future releases. Other future
features can be found in the TODO file.

<!-- vim: set tw=75: -->
