#
# restoredoctimes()
# Restore original timestamps for files in the /usr/doc directory.  This
# is part of the package design for all Slackware packages.  It's policy
# to maintain original timestamps for documentation.
#
# Parameters:   $1    The package name.
#               $2    The package tree.
#

restoredoctimes() {
   echo
   echo "Restoring original timestamps on /usr/doc files..."

   # get a list of files that fall into /usr/doc
   rm -rf $TMP/doc-$1
   mkdir -p $TMP/doc-$1
   find $2 -type f -print | grep "usr/doc" > $TMP/doc-$1/installed.lst

   # make a list of original files for each basename that got installed
   for installed in `cat $TMP/doc-$1/installed.lst`
   do
      find $TMP -type f -name `basename $installed` -print | \
         grep -v pkg-$1 >> \
         $TMP/doc-$1/`basename $installed`.orig.lst
   done

   # remove any lists that only consist of one file; messing with those
   # would just slow us down.
   for list in `find $TMP/doc-$1 -type f`
   do
      lines=`grep -c \$ $list`
      if [ $lines -eq 1 ]
      then
         rm -f $list
      fi
   done
 
   # loop of doom loop.
   #
   # for every file that got installed (in our installed.lst), do the
   # following:
   # 1) see if there is a corresponding basename.orig.lst
   # 1a) if not, that means there's only one file in $TMP with the same
   #     basename do a find in TMP and cp -a whatever turns up.
   # 1b) if so, loop through basename.orig.lst, comparing md5sums, until a
   #     match is found.  cp -a the matching file; all others are being
   #     written out to basename.orig.lst.checked, which is moved back to
   #     basename.orig.lst when done (thus eliminating matched file from
   #     list to be checked in the future)
   # 3) rinse, repeat.

   for installed in `cat $TMP/doc-$1/installed.lst`
   do
      base=`basename $installed`
      if [ ! -f "$TMP/doc-$1/$base.orig.lst" ]
      then
         original=$(find $TMP -type f -name `basename $installed` -print | \
                    grep -v pkg-$1)

         if [ "$VERBOSE" = "y" ]
         then
            # remove the TMP and PKG directory from the path
            tmpStart=`expr length $2`
            tmpStart=`expr $tmpStart + 1`
            tmpVar=$(expr substr $installed $tmpStart `expr length $installed`)

            # display the file we restored
            echo "   --> $tmpVar"

            # reclaim memory...maybe?...it's not exactly free() :)
            unset tmpVar tmpStart
         fi

         # We're now just touching files with the correct stamp instead of
         # recopying the file with cp -a
         #cp -a $original $installed
         touch -r $original $installed
      else
         installed_md5sum=`md5sum $installed | cut -d' ' -f1`
         nf=1
         for original in `cat $TMP/doc-$1/$base.orig.lst`
         do
            if [ "$nf" -a \
                 "$installed_md5sum" = "`md5sum $original | cut -d' ' -f1`" ]
            then
               unset nf
               # We're now just touching files with the correct stamp instead
               # of recopying the file with cp -a
               #cp -a $original $installed
               touch -r $original $installed
            else
               echo "$original" >> $TMP/doc-$1/$base.orig.lst.checked
            fi
         done

         mv $TMP/doc-$1/$base.orig.lst.checked \
            $TMP/doc-$1/$base.orig.lst
      fi
   done

   echo
}
