/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest;
import com.amazonaws.services.identitymanagement.model.ChangePasswordRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyResult;
import com.amazonaws.services.identitymanagement.model.CreateAccountAliasRequest;
import com.amazonaws.services.identitymanagement.model.CreateGroupRequest;
import com.amazonaws.services.identitymanagement.model.CreateGroupResult;
import com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.CreateInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest;
import com.amazonaws.services.identitymanagement.model.CreateLoginProfileResult;
import com.amazonaws.services.identitymanagement.model.CreateRoleRequest;
import com.amazonaws.services.identitymanagement.model.CreateRoleResult;
import com.amazonaws.services.identitymanagement.model.CreateUserRequest;
import com.amazonaws.services.identitymanagement.model.CreateUserResult;
import com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceResult;
import com.amazonaws.services.identitymanagement.model.DeactivateMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteAccountAliasRequest;
import com.amazonaws.services.identitymanagement.model.DeleteAccountPasswordPolicyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteGroupPolicyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteGroupRequest;
import com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.DeleteLoginProfileRequest;
import com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteRoleRequest;
import com.amazonaws.services.identitymanagement.model.DeleteServerCertificateRequest;
import com.amazonaws.services.identitymanagement.model.DeleteSigningCertificateRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserRequest;
import com.amazonaws.services.identitymanagement.model.DeleteVirtualMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.EnableMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.GetAccountPasswordPolicyRequest;
import com.amazonaws.services.identitymanagement.model.GetAccountPasswordPolicyResult;
import com.amazonaws.services.identitymanagement.model.GetAccountSummaryRequest;
import com.amazonaws.services.identitymanagement.model.GetAccountSummaryResult;
import com.amazonaws.services.identitymanagement.model.GetGroupPolicyRequest;
import com.amazonaws.services.identitymanagement.model.GetGroupPolicyResult;
import com.amazonaws.services.identitymanagement.model.GetGroupRequest;
import com.amazonaws.services.identitymanagement.model.GetGroupResult;
import com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.GetInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.GetLoginProfileRequest;
import com.amazonaws.services.identitymanagement.model.GetLoginProfileResult;
import com.amazonaws.services.identitymanagement.model.GetRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.GetRolePolicyResult;
import com.amazonaws.services.identitymanagement.model.GetRoleRequest;
import com.amazonaws.services.identitymanagement.model.GetRoleResult;
import com.amazonaws.services.identitymanagement.model.GetServerCertificateRequest;
import com.amazonaws.services.identitymanagement.model.GetServerCertificateResult;
import com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.GetUserPolicyResult;
import com.amazonaws.services.identitymanagement.model.GetUserRequest;
import com.amazonaws.services.identitymanagement.model.GetUserResult;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysResult;
import com.amazonaws.services.identitymanagement.model.ListAccountAliasesRequest;
import com.amazonaws.services.identitymanagement.model.ListAccountAliasesResult;
import com.amazonaws.services.identitymanagement.model.ListGroupPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListGroupPoliciesResult;
import com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest;
import com.amazonaws.services.identitymanagement.model.ListGroupsForUserResult;
import com.amazonaws.services.identitymanagement.model.ListGroupsRequest;
import com.amazonaws.services.identitymanagement.model.ListGroupsResult;
import com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest;
import com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleResult;
import com.amazonaws.services.identitymanagement.model.ListInstanceProfilesRequest;
import com.amazonaws.services.identitymanagement.model.ListInstanceProfilesResult;
import com.amazonaws.services.identitymanagement.model.ListMFADevicesRequest;
import com.amazonaws.services.identitymanagement.model.ListMFADevicesResult;
import com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListRolePoliciesResult;
import com.amazonaws.services.identitymanagement.model.ListRolesRequest;
import com.amazonaws.services.identitymanagement.model.ListRolesResult;
import com.amazonaws.services.identitymanagement.model.ListServerCertificatesRequest;
import com.amazonaws.services.identitymanagement.model.ListServerCertificatesResult;
import com.amazonaws.services.identitymanagement.model.ListSigningCertificatesRequest;
import com.amazonaws.services.identitymanagement.model.ListSigningCertificatesResult;
import com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListUserPoliciesResult;
import com.amazonaws.services.identitymanagement.model.ListUsersRequest;
import com.amazonaws.services.identitymanagement.model.ListUsersResult;
import com.amazonaws.services.identitymanagement.model.ListVirtualMFADevicesRequest;
import com.amazonaws.services.identitymanagement.model.ListVirtualMFADevicesResult;
import com.amazonaws.services.identitymanagement.model.PutGroupPolicyRequest;
import com.amazonaws.services.identitymanagement.model.PutRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest;
import com.amazonaws.services.identitymanagement.model.ResyncMFADeviceRequest;
import com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.UpdateAccountPasswordPolicyRequest;
import com.amazonaws.services.identitymanagement.model.UpdateAssumeRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.UpdateGroupRequest;
import com.amazonaws.services.identitymanagement.model.UpdateLoginProfileRequest;
import com.amazonaws.services.identitymanagement.model.UpdateServerCertificateRequest;
import com.amazonaws.services.identitymanagement.model.UpdateSigningCertificateRequest;
import com.amazonaws.services.identitymanagement.model.UpdateUserRequest;
import com.amazonaws.services.identitymanagement.model.UploadServerCertificateRequest;
import com.amazonaws.services.identitymanagement.model.UploadServerCertificateResult;
import com.amazonaws.services.identitymanagement.model.UploadSigningCertificateRequest;
import com.amazonaws.services.identitymanagement.model.UploadSigningCertificateResult;
import com.amazonaws.services.identitymanagement.model.transform.AddRoleToInstanceProfileRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.AddUserToGroupRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ChangePasswordRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateAccessKeyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateAccessKeyResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateAccountAliasRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateGroupRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateGroupResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateInstanceProfileRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateInstanceProfileResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateLoginProfileRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateLoginProfileResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateRoleRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateRoleResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateUserRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateUserResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateVirtualMFADeviceRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.CreateVirtualMFADeviceResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeactivateMFADeviceRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteAccessKeyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteAccountAliasRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteAccountPasswordPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteConflictExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteGroupPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteGroupRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteInstanceProfileRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteLoginProfileRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteRolePolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteRoleRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteServerCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteSigningCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteUserPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteUserRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DeleteVirtualMFADeviceRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.DuplicateCertificateExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.EnableMFADeviceRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.EntityAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.EntityTemporarilyUnmodifiableExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetAccountPasswordPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetAccountPasswordPolicyResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetAccountSummaryRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetAccountSummaryResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetGroupPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetGroupPolicyResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetGroupRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetGroupResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetInstanceProfileRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetInstanceProfileResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetLoginProfileRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetLoginProfileResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetRolePolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetRolePolicyResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetRoleRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetRoleResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetServerCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetServerCertificateResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetUserPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetUserPolicyResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetUserRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.GetUserResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.InvalidAuthenticationCodeExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.InvalidCertificateExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.InvalidUserTypeExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.KeyPairMismatchExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListAccessKeysRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListAccessKeysResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListAccountAliasesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListAccountAliasesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListGroupPoliciesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListGroupPoliciesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListGroupsForUserRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListGroupsForUserResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListGroupsRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListGroupsResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListInstanceProfilesForRoleRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListInstanceProfilesForRoleResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListInstanceProfilesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListInstanceProfilesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListMFADevicesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListMFADevicesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListRolePoliciesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListRolePoliciesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListRolesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListRolesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListServerCertificatesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListServerCertificatesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListSigningCertificatesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListSigningCertificatesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListUserPoliciesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListUserPoliciesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListUsersRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListUsersResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListVirtualMFADevicesRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ListVirtualMFADevicesResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.MalformedCertificateExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.MalformedPolicyDocumentExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.NoSuchEntityExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.PasswordPolicyViolationExceptionUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.PutGroupPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.PutRolePolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.PutUserPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.RemoveRoleFromInstanceProfileRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.RemoveUserFromGroupRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.ResyncMFADeviceRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateAccessKeyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateAccountPasswordPolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateAssumeRolePolicyRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateGroupRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateLoginProfileRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateServerCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateSigningCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UpdateUserRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UploadServerCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UploadServerCertificateResultStaxUnmarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UploadSigningCertificateRequestMarshaller;
import com.amazonaws.services.identitymanagement.model.transform.UploadSigningCertificateResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class AmazonIdentityManagementClient
extends AmazonWebServiceClient
implements AmazonIdentityManagement {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS4Signer signer;

    public AmazonIdentityManagementClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonIdentityManagementClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonIdentityManagementClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonIdentityManagementClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new DuplicateCertificateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidUserTypeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new EntityAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new KeyPairMismatchExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DeleteConflictExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidAuthenticationCodeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new EntityTemporarilyUnmodifiableExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MalformedCertificateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidCertificateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MalformedPolicyDocumentExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PasswordPolicyViolationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchEntityExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("iam.amazonaws.com");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("iam");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/identitymanagement/request.handlers"));
    }

    @Override
    public void deleteAccountAlias(DeleteAccountAliasRequest deleteAccountAliasRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteAccountAliasRequest> request = new DeleteAccountAliasRequestMarshaller().marshall(deleteAccountAliasRequest);
        this.invoke(request, null);
    }

    @Override
    public ListGroupsResult listGroups(ListGroupsRequest listGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListGroupsRequest> request = new ListGroupsRequestMarshaller().marshall(listGroupsRequest);
        return this.invoke(request, new ListGroupsResultStaxUnmarshaller());
    }

    @Override
    public void deleteAccessKey(DeleteAccessKeyRequest deleteAccessKeyRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteAccessKeyRequest> request = new DeleteAccessKeyRequestMarshaller().marshall(deleteAccessKeyRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteVirtualMFADevice(DeleteVirtualMFADeviceRequest deleteVirtualMFADeviceRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteVirtualMFADeviceRequest> request = new DeleteVirtualMFADeviceRequestMarshaller().marshall(deleteVirtualMFADeviceRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteUserPolicy(DeleteUserPolicyRequest deleteUserPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteUserPolicyRequest> request = new DeleteUserPolicyRequestMarshaller().marshall(deleteUserPolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public void putUserPolicy(PutUserPolicyRequest putUserPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<PutUserPolicyRequest> request = new PutUserPolicyRequestMarshaller().marshall(putUserPolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public ListServerCertificatesResult listServerCertificates(ListServerCertificatesRequest listServerCertificatesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListServerCertificatesRequest> request = new ListServerCertificatesRequestMarshaller().marshall(listServerCertificatesRequest);
        return this.invoke(request, new ListServerCertificatesResultStaxUnmarshaller());
    }

    @Override
    public GetUserPolicyResult getUserPolicy(GetUserPolicyRequest getUserPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetUserPolicyRequest> request = new GetUserPolicyRequestMarshaller().marshall(getUserPolicyRequest);
        return this.invoke(request, new GetUserPolicyResultStaxUnmarshaller());
    }

    @Override
    public void updateServerCertificate(UpdateServerCertificateRequest updateServerCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateServerCertificateRequest> request = new UpdateServerCertificateRequestMarshaller().marshall(updateServerCertificateRequest);
        this.invoke(request, null);
    }

    @Override
    public void updateUser(UpdateUserRequest updateUserRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateUserRequest> request = new UpdateUserRequestMarshaller().marshall(updateUserRequest);
        this.invoke(request, null);
    }

    @Override
    public void putRolePolicy(PutRolePolicyRequest putRolePolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<PutRolePolicyRequest> request = new PutRolePolicyRequestMarshaller().marshall(putRolePolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public void updateSigningCertificate(UpdateSigningCertificateRequest updateSigningCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateSigningCertificateRequest> request = new UpdateSigningCertificateRequestMarshaller().marshall(updateSigningCertificateRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteGroupPolicy(DeleteGroupPolicyRequest deleteGroupPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteGroupPolicyRequest> request = new DeleteGroupPolicyRequestMarshaller().marshall(deleteGroupPolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public ListUsersResult listUsers(ListUsersRequest listUsersRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListUsersRequest> request = new ListUsersRequestMarshaller().marshall(listUsersRequest);
        return this.invoke(request, new ListUsersResultStaxUnmarshaller());
    }

    @Override
    public void updateGroup(UpdateGroupRequest updateGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateGroupRequest> request = new UpdateGroupRequestMarshaller().marshall(updateGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public CreateUserResult createUser(CreateUserRequest createUserRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateUserRequest> request = new CreateUserRequestMarshaller().marshall(createUserRequest);
        return this.invoke(request, new CreateUserResultStaxUnmarshaller());
    }

    @Override
    public void enableMFADevice(EnableMFADeviceRequest enableMFADeviceRequest) throws AmazonServiceException, AmazonClientException {
        Request<EnableMFADeviceRequest> request = new EnableMFADeviceRequestMarshaller().marshall(enableMFADeviceRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteAccountPasswordPolicy(DeleteAccountPasswordPolicyRequest deleteAccountPasswordPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteAccountPasswordPolicyRequest> request = new DeleteAccountPasswordPolicyRequestMarshaller().marshall(deleteAccountPasswordPolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public GetLoginProfileResult getLoginProfile(GetLoginProfileRequest getLoginProfileRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetLoginProfileRequest> request = new GetLoginProfileRequestMarshaller().marshall(getLoginProfileRequest);
        return this.invoke(request, new GetLoginProfileResultStaxUnmarshaller());
    }

    @Override
    public UploadServerCertificateResult uploadServerCertificate(UploadServerCertificateRequest uploadServerCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<UploadServerCertificateRequest> request = new UploadServerCertificateRequestMarshaller().marshall(uploadServerCertificateRequest);
        return this.invoke(request, new UploadServerCertificateResultStaxUnmarshaller());
    }

    @Override
    public CreateGroupResult createGroup(CreateGroupRequest createGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateGroupRequest> request = new CreateGroupRequestMarshaller().marshall(createGroupRequest);
        return this.invoke(request, new CreateGroupResultStaxUnmarshaller());
    }

    @Override
    public void createAccountAlias(CreateAccountAliasRequest createAccountAliasRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateAccountAliasRequest> request = new CreateAccountAliasRequestMarshaller().marshall(createAccountAliasRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteUser(DeleteUserRequest deleteUserRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteUserRequest> request = new DeleteUserRequestMarshaller().marshall(deleteUserRequest);
        this.invoke(request, null);
    }

    @Override
    public void deactivateMFADevice(DeactivateMFADeviceRequest deactivateMFADeviceRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeactivateMFADeviceRequest> request = new DeactivateMFADeviceRequestMarshaller().marshall(deactivateMFADeviceRequest);
        this.invoke(request, null);
    }

    @Override
    public void removeUserFromGroup(RemoveUserFromGroupRequest removeUserFromGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<RemoveUserFromGroupRequest> request = new RemoveUserFromGroupRequestMarshaller().marshall(removeUserFromGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteRole(DeleteRoleRequest deleteRoleRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteRoleRequest> request = new DeleteRoleRequestMarshaller().marshall(deleteRoleRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteServerCertificate(DeleteServerCertificateRequest deleteServerCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteServerCertificateRequest> request = new DeleteServerCertificateRequestMarshaller().marshall(deleteServerCertificateRequest);
        this.invoke(request, null);
    }

    @Override
    public CreateAccessKeyResult createAccessKey(CreateAccessKeyRequest createAccessKeyRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateAccessKeyRequest> request = new CreateAccessKeyRequestMarshaller().marshall(createAccessKeyRequest);
        return this.invoke(request, new CreateAccessKeyResultStaxUnmarshaller());
    }

    @Override
    public GetUserResult getUser(GetUserRequest getUserRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetUserRequest> request = new GetUserRequestMarshaller().marshall(getUserRequest);
        return this.invoke(request, new GetUserResultStaxUnmarshaller());
    }

    @Override
    public void resyncMFADevice(ResyncMFADeviceRequest resyncMFADeviceRequest) throws AmazonServiceException, AmazonClientException {
        Request<ResyncMFADeviceRequest> request = new ResyncMFADeviceRequestMarshaller().marshall(resyncMFADeviceRequest);
        this.invoke(request, null);
    }

    @Override
    public ListMFADevicesResult listMFADevices(ListMFADevicesRequest listMFADevicesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListMFADevicesRequest> request = new ListMFADevicesRequestMarshaller().marshall(listMFADevicesRequest);
        return this.invoke(request, new ListMFADevicesResultStaxUnmarshaller());
    }

    @Override
    public CreateVirtualMFADeviceResult createVirtualMFADevice(CreateVirtualMFADeviceRequest createVirtualMFADeviceRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateVirtualMFADeviceRequest> request = new CreateVirtualMFADeviceRequestMarshaller().marshall(createVirtualMFADeviceRequest);
        return this.invoke(request, new CreateVirtualMFADeviceResultStaxUnmarshaller());
    }

    @Override
    public ListInstanceProfilesResult listInstanceProfiles(ListInstanceProfilesRequest listInstanceProfilesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListInstanceProfilesRequest> request = new ListInstanceProfilesRequestMarshaller().marshall(listInstanceProfilesRequest);
        return this.invoke(request, new ListInstanceProfilesResultStaxUnmarshaller());
    }

    @Override
    public void updateAccessKey(UpdateAccessKeyRequest updateAccessKeyRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateAccessKeyRequest> request = new UpdateAccessKeyRequestMarshaller().marshall(updateAccessKeyRequest);
        this.invoke(request, null);
    }

    @Override
    public void addUserToGroup(AddUserToGroupRequest addUserToGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<AddUserToGroupRequest> request = new AddUserToGroupRequestMarshaller().marshall(addUserToGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public GetGroupResult getGroup(GetGroupRequest getGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetGroupRequest> request = new GetGroupRequestMarshaller().marshall(getGroupRequest);
        return this.invoke(request, new GetGroupResultStaxUnmarshaller());
    }

    @Override
    public ListAccountAliasesResult listAccountAliases(ListAccountAliasesRequest listAccountAliasesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListAccountAliasesRequest> request = new ListAccountAliasesRequestMarshaller().marshall(listAccountAliasesRequest);
        return this.invoke(request, new ListAccountAliasesResultStaxUnmarshaller());
    }

    @Override
    public void deleteGroup(DeleteGroupRequest deleteGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteGroupRequest> request = new DeleteGroupRequestMarshaller().marshall(deleteGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public GetRoleResult getRole(GetRoleRequest getRoleRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetRoleRequest> request = new GetRoleRequestMarshaller().marshall(getRoleRequest);
        return this.invoke(request, new GetRoleResultStaxUnmarshaller());
    }

    @Override
    public ListRolePoliciesResult listRolePolicies(ListRolePoliciesRequest listRolePoliciesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListRolePoliciesRequest> request = new ListRolePoliciesRequestMarshaller().marshall(listRolePoliciesRequest);
        return this.invoke(request, new ListRolePoliciesResultStaxUnmarshaller());
    }

    @Override
    public ListSigningCertificatesResult listSigningCertificates(ListSigningCertificatesRequest listSigningCertificatesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListSigningCertificatesRequest> request = new ListSigningCertificatesRequestMarshaller().marshall(listSigningCertificatesRequest);
        return this.invoke(request, new ListSigningCertificatesResultStaxUnmarshaller());
    }

    @Override
    public UploadSigningCertificateResult uploadSigningCertificate(UploadSigningCertificateRequest uploadSigningCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<UploadSigningCertificateRequest> request = new UploadSigningCertificateRequestMarshaller().marshall(uploadSigningCertificateRequest);
        return this.invoke(request, new UploadSigningCertificateResultStaxUnmarshaller());
    }

    @Override
    public void deleteInstanceProfile(DeleteInstanceProfileRequest deleteInstanceProfileRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteInstanceProfileRequest> request = new DeleteInstanceProfileRequestMarshaller().marshall(deleteInstanceProfileRequest);
        this.invoke(request, null);
    }

    @Override
    public CreateRoleResult createRole(CreateRoleRequest createRoleRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateRoleRequest> request = new CreateRoleRequestMarshaller().marshall(createRoleRequest);
        return this.invoke(request, new CreateRoleResultStaxUnmarshaller());
    }

    @Override
    public void updateLoginProfile(UpdateLoginProfileRequest updateLoginProfileRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateLoginProfileRequest> request = new UpdateLoginProfileRequestMarshaller().marshall(updateLoginProfileRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteLoginProfile(DeleteLoginProfileRequest deleteLoginProfileRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteLoginProfileRequest> request = new DeleteLoginProfileRequestMarshaller().marshall(deleteLoginProfileRequest);
        this.invoke(request, null);
    }

    @Override
    public void changePassword(ChangePasswordRequest changePasswordRequest) throws AmazonServiceException, AmazonClientException {
        Request<ChangePasswordRequest> request = new ChangePasswordRequestMarshaller().marshall(changePasswordRequest);
        this.invoke(request, null);
    }

    @Override
    public GetServerCertificateResult getServerCertificate(GetServerCertificateRequest getServerCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetServerCertificateRequest> request = new GetServerCertificateRequestMarshaller().marshall(getServerCertificateRequest);
        return this.invoke(request, new GetServerCertificateResultStaxUnmarshaller());
    }

    @Override
    public void putGroupPolicy(PutGroupPolicyRequest putGroupPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<PutGroupPolicyRequest> request = new PutGroupPolicyRequestMarshaller().marshall(putGroupPolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteSigningCertificate(DeleteSigningCertificateRequest deleteSigningCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteSigningCertificateRequest> request = new DeleteSigningCertificateRequestMarshaller().marshall(deleteSigningCertificateRequest);
        this.invoke(request, null);
    }

    @Override
    public ListUserPoliciesResult listUserPolicies(ListUserPoliciesRequest listUserPoliciesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListUserPoliciesRequest> request = new ListUserPoliciesRequestMarshaller().marshall(listUserPoliciesRequest);
        return this.invoke(request, new ListUserPoliciesResultStaxUnmarshaller());
    }

    @Override
    public ListAccessKeysResult listAccessKeys(ListAccessKeysRequest listAccessKeysRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListAccessKeysRequest> request = new ListAccessKeysRequestMarshaller().marshall(listAccessKeysRequest);
        return this.invoke(request, new ListAccessKeysResultStaxUnmarshaller());
    }

    @Override
    public ListGroupsForUserResult listGroupsForUser(ListGroupsForUserRequest listGroupsForUserRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListGroupsForUserRequest> request = new ListGroupsForUserRequestMarshaller().marshall(listGroupsForUserRequest);
        return this.invoke(request, new ListGroupsForUserResultStaxUnmarshaller());
    }

    @Override
    public void addRoleToInstanceProfile(AddRoleToInstanceProfileRequest addRoleToInstanceProfileRequest) throws AmazonServiceException, AmazonClientException {
        Request<AddRoleToInstanceProfileRequest> request = new AddRoleToInstanceProfileRequestMarshaller().marshall(addRoleToInstanceProfileRequest);
        this.invoke(request, null);
    }

    @Override
    public GetGroupPolicyResult getGroupPolicy(GetGroupPolicyRequest getGroupPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetGroupPolicyRequest> request = new GetGroupPolicyRequestMarshaller().marshall(getGroupPolicyRequest);
        return this.invoke(request, new GetGroupPolicyResultStaxUnmarshaller());
    }

    @Override
    public GetRolePolicyResult getRolePolicy(GetRolePolicyRequest getRolePolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetRolePolicyRequest> request = new GetRolePolicyRequestMarshaller().marshall(getRolePolicyRequest);
        return this.invoke(request, new GetRolePolicyResultStaxUnmarshaller());
    }

    @Override
    public ListInstanceProfilesForRoleResult listInstanceProfilesForRole(ListInstanceProfilesForRoleRequest listInstanceProfilesForRoleRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListInstanceProfilesForRoleRequest> request = new ListInstanceProfilesForRoleRequestMarshaller().marshall(listInstanceProfilesForRoleRequest);
        return this.invoke(request, new ListInstanceProfilesForRoleResultStaxUnmarshaller());
    }

    @Override
    public ListVirtualMFADevicesResult listVirtualMFADevices(ListVirtualMFADevicesRequest listVirtualMFADevicesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListVirtualMFADevicesRequest> request = new ListVirtualMFADevicesRequestMarshaller().marshall(listVirtualMFADevicesRequest);
        return this.invoke(request, new ListVirtualMFADevicesResultStaxUnmarshaller());
    }

    @Override
    public void deleteRolePolicy(DeleteRolePolicyRequest deleteRolePolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteRolePolicyRequest> request = new DeleteRolePolicyRequestMarshaller().marshall(deleteRolePolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public CreateInstanceProfileResult createInstanceProfile(CreateInstanceProfileRequest createInstanceProfileRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateInstanceProfileRequest> request = new CreateInstanceProfileRequestMarshaller().marshall(createInstanceProfileRequest);
        return this.invoke(request, new CreateInstanceProfileResultStaxUnmarshaller());
    }

    @Override
    public ListGroupPoliciesResult listGroupPolicies(ListGroupPoliciesRequest listGroupPoliciesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListGroupPoliciesRequest> request = new ListGroupPoliciesRequestMarshaller().marshall(listGroupPoliciesRequest);
        return this.invoke(request, new ListGroupPoliciesResultStaxUnmarshaller());
    }

    @Override
    public CreateLoginProfileResult createLoginProfile(CreateLoginProfileRequest createLoginProfileRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateLoginProfileRequest> request = new CreateLoginProfileRequestMarshaller().marshall(createLoginProfileRequest);
        return this.invoke(request, new CreateLoginProfileResultStaxUnmarshaller());
    }

    @Override
    public void removeRoleFromInstanceProfile(RemoveRoleFromInstanceProfileRequest removeRoleFromInstanceProfileRequest) throws AmazonServiceException, AmazonClientException {
        Request<RemoveRoleFromInstanceProfileRequest> request = new RemoveRoleFromInstanceProfileRequestMarshaller().marshall(removeRoleFromInstanceProfileRequest);
        this.invoke(request, null);
    }

    @Override
    public void updateAccountPasswordPolicy(UpdateAccountPasswordPolicyRequest updateAccountPasswordPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateAccountPasswordPolicyRequest> request = new UpdateAccountPasswordPolicyRequestMarshaller().marshall(updateAccountPasswordPolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public void updateAssumeRolePolicy(UpdateAssumeRolePolicyRequest updateAssumeRolePolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateAssumeRolePolicyRequest> request = new UpdateAssumeRolePolicyRequestMarshaller().marshall(updateAssumeRolePolicyRequest);
        this.invoke(request, null);
    }

    @Override
    public GetInstanceProfileResult getInstanceProfile(GetInstanceProfileRequest getInstanceProfileRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetInstanceProfileRequest> request = new GetInstanceProfileRequestMarshaller().marshall(getInstanceProfileRequest);
        return this.invoke(request, new GetInstanceProfileResultStaxUnmarshaller());
    }

    @Override
    public ListRolesResult listRoles(ListRolesRequest listRolesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListRolesRequest> request = new ListRolesRequestMarshaller().marshall(listRolesRequest);
        return this.invoke(request, new ListRolesResultStaxUnmarshaller());
    }

    @Override
    public GetAccountSummaryResult getAccountSummary(GetAccountSummaryRequest getAccountSummaryRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetAccountSummaryRequest> request = new GetAccountSummaryRequestMarshaller().marshall(getAccountSummaryRequest);
        return this.invoke(request, new GetAccountSummaryResultStaxUnmarshaller());
    }

    @Override
    public GetAccountPasswordPolicyResult getAccountPasswordPolicy(GetAccountPasswordPolicyRequest getAccountPasswordPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetAccountPasswordPolicyRequest> request = new GetAccountPasswordPolicyRequestMarshaller().marshall(getAccountPasswordPolicyRequest);
        return this.invoke(request, new GetAccountPasswordPolicyResultStaxUnmarshaller());
    }

    @Override
    public ListGroupsResult listGroups() throws AmazonServiceException, AmazonClientException {
        return this.listGroups(new ListGroupsRequest());
    }

    @Override
    public ListServerCertificatesResult listServerCertificates() throws AmazonServiceException, AmazonClientException {
        return this.listServerCertificates(new ListServerCertificatesRequest());
    }

    @Override
    public ListUsersResult listUsers() throws AmazonServiceException, AmazonClientException {
        return this.listUsers(new ListUsersRequest());
    }

    @Override
    public void deleteAccountPasswordPolicy() throws AmazonServiceException, AmazonClientException {
        this.deleteAccountPasswordPolicy(new DeleteAccountPasswordPolicyRequest());
    }

    @Override
    public CreateAccessKeyResult createAccessKey() throws AmazonServiceException, AmazonClientException {
        return this.createAccessKey(new CreateAccessKeyRequest());
    }

    @Override
    public GetUserResult getUser() throws AmazonServiceException, AmazonClientException {
        return this.getUser(new GetUserRequest());
    }

    @Override
    public ListMFADevicesResult listMFADevices() throws AmazonServiceException, AmazonClientException {
        return this.listMFADevices(new ListMFADevicesRequest());
    }

    @Override
    public ListInstanceProfilesResult listInstanceProfiles() throws AmazonServiceException, AmazonClientException {
        return this.listInstanceProfiles(new ListInstanceProfilesRequest());
    }

    @Override
    public ListAccountAliasesResult listAccountAliases() throws AmazonServiceException, AmazonClientException {
        return this.listAccountAliases(new ListAccountAliasesRequest());
    }

    @Override
    public ListSigningCertificatesResult listSigningCertificates() throws AmazonServiceException, AmazonClientException {
        return this.listSigningCertificates(new ListSigningCertificatesRequest());
    }

    @Override
    public ListAccessKeysResult listAccessKeys() throws AmazonServiceException, AmazonClientException {
        return this.listAccessKeys(new ListAccessKeysRequest());
    }

    @Override
    public ListVirtualMFADevicesResult listVirtualMFADevices() throws AmazonServiceException, AmazonClientException {
        return this.listVirtualMFADevices(new ListVirtualMFADevicesRequest());
    }

    @Override
    public ListRolesResult listRoles() throws AmazonServiceException, AmazonClientException {
        return this.listRoles(new ListRolesRequest());
    }

    @Override
    public GetAccountSummaryResult getAccountSummary() throws AmazonServiceException, AmazonClientException {
        return this.getAccountSummary(new GetAccountSummaryRequest());
    }

    @Override
    public GetAccountPasswordPolicyResult getAccountPasswordPolicy() throws AmazonServiceException, AmazonClientException {
        return this.getAccountPasswordPolicy(new GetAccountPasswordPolicyRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

