package logz

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// LiftrResourceCategories enumerates the values for liftr resource categories.
type LiftrResourceCategories string

const (
	// LiftrResourceCategoriesMonitorLogs ...
	LiftrResourceCategoriesMonitorLogs LiftrResourceCategories = "MonitorLogs"
	// LiftrResourceCategoriesUnknown ...
	LiftrResourceCategoriesUnknown LiftrResourceCategories = "Unknown"
)

// PossibleLiftrResourceCategoriesValues returns an array of possible values for the LiftrResourceCategories const type.
func PossibleLiftrResourceCategoriesValues() []LiftrResourceCategories {
	return []LiftrResourceCategories{LiftrResourceCategoriesMonitorLogs, LiftrResourceCategoriesUnknown}
}

// ManagedIdentityTypes enumerates the values for managed identity types.
type ManagedIdentityTypes string

const (
	// ManagedIdentityTypesSystemAssigned ...
	ManagedIdentityTypesSystemAssigned ManagedIdentityTypes = "SystemAssigned"
	// ManagedIdentityTypesUserAssigned ...
	ManagedIdentityTypesUserAssigned ManagedIdentityTypes = "UserAssigned"
)

// PossibleManagedIdentityTypesValues returns an array of possible values for the ManagedIdentityTypes const type.
func PossibleManagedIdentityTypesValues() []ManagedIdentityTypes {
	return []ManagedIdentityTypes{ManagedIdentityTypesSystemAssigned, ManagedIdentityTypesUserAssigned}
}

// MarketplaceSubscriptionStatus enumerates the values for marketplace subscription status.
type MarketplaceSubscriptionStatus string

const (
	// MarketplaceSubscriptionStatusActive ...
	MarketplaceSubscriptionStatusActive MarketplaceSubscriptionStatus = "Active"
	// MarketplaceSubscriptionStatusSuspended ...
	MarketplaceSubscriptionStatusSuspended MarketplaceSubscriptionStatus = "Suspended"
)

// PossibleMarketplaceSubscriptionStatusValues returns an array of possible values for the MarketplaceSubscriptionStatus const type.
func PossibleMarketplaceSubscriptionStatusValues() []MarketplaceSubscriptionStatus {
	return []MarketplaceSubscriptionStatus{MarketplaceSubscriptionStatusActive, MarketplaceSubscriptionStatusSuspended}
}

// MonitoringStatus enumerates the values for monitoring status.
type MonitoringStatus string

const (
	// MonitoringStatusDisabled ...
	MonitoringStatusDisabled MonitoringStatus = "Disabled"
	// MonitoringStatusEnabled ...
	MonitoringStatusEnabled MonitoringStatus = "Enabled"
)

// PossibleMonitoringStatusValues returns an array of possible values for the MonitoringStatus const type.
func PossibleMonitoringStatusValues() []MonitoringStatus {
	return []MonitoringStatus{MonitoringStatusDisabled, MonitoringStatusEnabled}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateAccepted ...
	ProvisioningStateAccepted ProvisioningState = "Accepted"
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleted ...
	ProvisioningStateDeleted ProvisioningState = "Deleted"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateNotSpecified ...
	ProvisioningStateNotSpecified ProvisioningState = "NotSpecified"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateAccepted, ProvisioningStateCanceled, ProvisioningStateCreating, ProvisioningStateDeleted, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateNotSpecified, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// SingleSignOnStates enumerates the values for single sign on states.
type SingleSignOnStates string

const (
	// SingleSignOnStatesDisable ...
	SingleSignOnStatesDisable SingleSignOnStates = "Disable"
	// SingleSignOnStatesEnable ...
	SingleSignOnStatesEnable SingleSignOnStates = "Enable"
	// SingleSignOnStatesExisting ...
	SingleSignOnStatesExisting SingleSignOnStates = "Existing"
	// SingleSignOnStatesInitial ...
	SingleSignOnStatesInitial SingleSignOnStates = "Initial"
)

// PossibleSingleSignOnStatesValues returns an array of possible values for the SingleSignOnStates const type.
func PossibleSingleSignOnStatesValues() []SingleSignOnStates {
	return []SingleSignOnStates{SingleSignOnStatesDisable, SingleSignOnStatesEnable, SingleSignOnStatesExisting, SingleSignOnStatesInitial}
}

// TagAction enumerates the values for tag action.
type TagAction string

const (
	// TagActionExclude ...
	TagActionExclude TagAction = "Exclude"
	// TagActionInclude ...
	TagActionInclude TagAction = "Include"
)

// PossibleTagActionValues returns an array of possible values for the TagAction const type.
func PossibleTagActionValues() []TagAction {
	return []TagAction{TagActionExclude, TagActionInclude}
}

// UserRole enumerates the values for user role.
type UserRole string

const (
	// UserRoleAdmin ...
	UserRoleAdmin UserRole = "Admin"
	// UserRoleNone ...
	UserRoleNone UserRole = "None"
	// UserRoleUser ...
	UserRoleUser UserRole = "User"
)

// PossibleUserRoleValues returns an array of possible values for the UserRole const type.
func PossibleUserRoleValues() []UserRole {
	return []UserRole{UserRoleAdmin, UserRoleNone, UserRoleUser}
}

// VMHostUpdateStates enumerates the values for vm host update states.
type VMHostUpdateStates string

const (
	// VMHostUpdateStatesDelete ...
	VMHostUpdateStatesDelete VMHostUpdateStates = "Delete"
	// VMHostUpdateStatesInstall ...
	VMHostUpdateStatesInstall VMHostUpdateStates = "Install"
)

// PossibleVMHostUpdateStatesValues returns an array of possible values for the VMHostUpdateStates const type.
func PossibleVMHostUpdateStatesValues() []VMHostUpdateStates {
	return []VMHostUpdateStates{VMHostUpdateStatesDelete, VMHostUpdateStatesInstall}
}
