package subscriptions

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// LocationType enumerates the values for location type.
type LocationType string

const (
	// LocationTypeEdgeZone ...
	LocationTypeEdgeZone LocationType = "EdgeZone"
	// LocationTypeRegion ...
	LocationTypeRegion LocationType = "Region"
)

// PossibleLocationTypeValues returns an array of possible values for the LocationType const type.
func PossibleLocationTypeValues() []LocationType {
	return []LocationType{LocationTypeEdgeZone, LocationTypeRegion}
}

// RegionCategory enumerates the values for region category.
type RegionCategory string

const (
	// RegionCategoryExtended ...
	RegionCategoryExtended RegionCategory = "Extended"
	// RegionCategoryOther ...
	RegionCategoryOther RegionCategory = "Other"
	// RegionCategoryRecommended ...
	RegionCategoryRecommended RegionCategory = "Recommended"
)

// PossibleRegionCategoryValues returns an array of possible values for the RegionCategory const type.
func PossibleRegionCategoryValues() []RegionCategory {
	return []RegionCategory{RegionCategoryExtended, RegionCategoryOther, RegionCategoryRecommended}
}

// RegionType enumerates the values for region type.
type RegionType string

const (
	// RegionTypeLogical ...
	RegionTypeLogical RegionType = "Logical"
	// RegionTypePhysical ...
	RegionTypePhysical RegionType = "Physical"
)

// PossibleRegionTypeValues returns an array of possible values for the RegionType const type.
func PossibleRegionTypeValues() []RegionType {
	return []RegionType{RegionTypeLogical, RegionTypePhysical}
}

// ResourceNameStatus enumerates the values for resource name status.
type ResourceNameStatus string

const (
	// ResourceNameStatusAllowed ...
	ResourceNameStatusAllowed ResourceNameStatus = "Allowed"
	// ResourceNameStatusReserved ...
	ResourceNameStatusReserved ResourceNameStatus = "Reserved"
)

// PossibleResourceNameStatusValues returns an array of possible values for the ResourceNameStatus const type.
func PossibleResourceNameStatusValues() []ResourceNameStatus {
	return []ResourceNameStatus{ResourceNameStatusAllowed, ResourceNameStatusReserved}
}

// SpendingLimit enumerates the values for spending limit.
type SpendingLimit string

const (
	// SpendingLimitCurrentPeriodOff ...
	SpendingLimitCurrentPeriodOff SpendingLimit = "CurrentPeriodOff"
	// SpendingLimitOff ...
	SpendingLimitOff SpendingLimit = "Off"
	// SpendingLimitOn ...
	SpendingLimitOn SpendingLimit = "On"
)

// PossibleSpendingLimitValues returns an array of possible values for the SpendingLimit const type.
func PossibleSpendingLimitValues() []SpendingLimit {
	return []SpendingLimit{SpendingLimitCurrentPeriodOff, SpendingLimitOff, SpendingLimitOn}
}

// State enumerates the values for state.
type State string

const (
	// StateDeleted ...
	StateDeleted State = "Deleted"
	// StateDisabled ...
	StateDisabled State = "Disabled"
	// StateEnabled ...
	StateEnabled State = "Enabled"
	// StatePastDue ...
	StatePastDue State = "PastDue"
	// StateWarned ...
	StateWarned State = "Warned"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateDeleted, StateDisabled, StateEnabled, StatePastDue, StateWarned}
}

// TenantCategory enumerates the values for tenant category.
type TenantCategory string

const (
	// TenantCategoryHome ...
	TenantCategoryHome TenantCategory = "Home"
	// TenantCategoryManagedBy ...
	TenantCategoryManagedBy TenantCategory = "ManagedBy"
	// TenantCategoryProjectedBy ...
	TenantCategoryProjectedBy TenantCategory = "ProjectedBy"
)

// PossibleTenantCategoryValues returns an array of possible values for the TenantCategory const type.
func PossibleTenantCategoryValues() []TenantCategory {
	return []TenantCategory{TenantCategoryHome, TenantCategoryManagedBy, TenantCategoryProjectedBy}
}
