/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.Sequence;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public final class XSLSequence
extends StyleElement {
    private Expression select;
    SequenceType requiredType = null;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        if (this.requiredType == null) {
            if (this.select != null) {
                return this.select.getItemType();
            }
            return this.getCommonChildItemType();
        }
        return this.requiredType.getPrimaryType();
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        String string2 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string3 = this.getNamePool().getClarkName(n2);
            if (string3 == "select") {
                string = attributeCollection.getValue(n);
            } else if (string3 == "as") {
                string2 = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
        if (string2 != null) {
            this.requiredType = this.makeSequenceType(string2);
        }
    }

    public void validate() throws TransformerConfigurationException {
        block3: {
            this.checkWithinTemplate();
            if (this.select != null && this.hasChildNodes()) {
                this.compileError("If xsl:sequence has a select attribute, it must not have child instructions");
            }
            this.select = this.typeCheck("select", this.select);
            if (this.select == null || this.requiredType == null) break block3;
            try {
                RoleLocator roleLocator = new RoleLocator(4, "xsl:sequence/select", 0);
                this.select = TypeChecker.staticTypeCheck(this.select, this.requiredType, false, roleLocator);
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
    }

    public void markTailCalls() {
        if (this.requiredType != null) {
            StyleElement styleElement = this.getLastChildInstruction();
            if (styleElement != null) {
                styleElement.markTailCalls();
            } else if (this.select != null) {
                ExpressionTool.markTailFunctionCalls(this.select);
            }
        }
    }

    public Instruction compile() throws TransformerConfigurationException {
        Sequence sequence = new Sequence(this.select, this.requiredType);
        this.compileChildren(sequence);
        return sequence;
    }
}

