# Copyright (c) 2025 Thomas Goirand
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import datetime
import json
import uuid


def make_fake_migration(**kwargs):
    """Create a fake migration object."""
    fake_migration = {
        'id': kwargs.get('id', str(uuid.uuid4())),
        'vm_id': kwargs.get('vm_id', str(uuid.uuid4())),
        'vm_name': kwargs.get('vm_name', 'test-vm'),
        'scheduled_time': kwargs.get('scheduled_time', None),
        'state': kwargs.get('state', 'SCHEDULED'),
        'created_at': kwargs.get('created_at', datetime.datetime.now().isoformat()),
        'updated_at': kwargs.get('updated_at', datetime.datetime.now().isoformat()),
    }
    return fake_migration


FAKE_MIGRATIONS = [
    make_fake_migration(vm_name='test-vm-1', state='SCHEDULED'),
    make_fake_migration(vm_name='test-vm-2', state='MIGRATED'),
    make_fake_migration(vm_name='scheduled-vm', state='SCHEDULED', 
                       scheduled_time='2025-10-07T22:00:00'),
]
